/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.menu.service.impl;

import com.yonyou.iuap.cache.CacheManager;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.tenant.sdk.UserCenter;
import com.yyjz.icop.menu.entity.PTMenu;
import com.yyjz.icop.menu.repository.PTMenuDao;
import com.yyjz.icop.menu.service.IPTMenuService;
import com.yyjz.icop.menu.vo.MenuVal;
import com.yyjz.icop.menu.vo.MenuVo;
import com.yyjz.icop.menu.vo.SidebarMenu;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;
import com.yyjz.icop.utils.CommonUtils;
import com.yyjz.icop.utils.IntegrationVerifyUtils;
import com.yyjz.icop.utils.MenuCompartor;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PTMenuServiceImpl
implements IPTMenuService {
    private Logger log = LoggerFactory.getLogger(PTMenuServiceImpl.class);
    @Autowired
    private PTMenuDao menuDao;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IAppService appService;
    @Autowired
    private IUserService userService;
    private static final String tenantId = "global";

    public List<PTMenu> getAllList(String rootId) {
        return (List)this.menuDao.findAll();
    }

    @Transactional
    public MenuVo saveEntity(MenuVo vo) {
        PTMenu e = new PTMenu();
        BeanUtils.copyProperties((Object)vo, (Object)e);
        if (e.getId() == null) {
            e.setId(CommonUtils.getEntityId());
            e.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        e = (PTMenu)this.menuDao.save(e);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public List<MenuVo> listAllTree() {
        MenuVo root = this.getVirtualRoot();
        List<MenuVo> results = this.getChildrenNodes(root.getId());
        if (results == null) {
            results = new ArrayList<MenuVo>();
        }
        return results;
    }

    public List<MenuVo> getChildrenNodes(String parentId) {
        String isPermissionVerify = IntegrationVerifyUtils.isPermissionVerify();
        if (Boolean.valueOf(isPermissionVerify).booleanValue()) {
            return this.getChildrenNodesnew(parentId, "");
        }
        String label = "";
        return this.getChildrenNodesnew(parentId, label);
    }

    public List<MenuVo> getChildrenNodesnew(String parentId, String label) {
        List<MenuVo> nodes = this.findByParentId(parentId);
        ArrayList<MenuVo> results = new ArrayList<MenuVo>();
        if (!nodes.isEmpty()) {
            for (MenuVo i : nodes) {
                List<MenuVo> tmp;
                String isPermissionVerify = IntegrationVerifyUtils.isPermissionVerify();
                if (Boolean.valueOf(isPermissionVerify).booleanValue()) {
                    results.add(i);
                    tmp = this.getChildrenNodesnew(i.getId(), label);
                    if (tmp.isEmpty()) continue;
                    results.addAll(tmp);
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)label) && label.equals(i.getLabel()) || "common".equals(i.getLabel())) {
                    // empty if block
                }
                results.add(i);
                tmp = this.getChildrenNodesnew(i.getId(), label);
                if (tmp.isEmpty()) continue;
                results.addAll(tmp);
            }
        }
        return results;
    }

    public List<MenuVo> findByParentId(String parentId) {
        List<PTMenu> es = this.menuDao.findByParentId(parentId);
        ArrayList<MenuVo> vos = new ArrayList<MenuVo>();
        for (PTMenu e : es) {
            MenuVo v = new MenuVo();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<MenuVo> findByParentIdVal(String parentId) {
        List<PTMenu> es = this.menuDao.findByParentIdVal(parentId);
        ArrayList<MenuVo> vos = new ArrayList<MenuVo>();
        for (PTMenu e : es) {
            MenuVo v = new MenuVo();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public MenuVo findById(String id) {
        MenuVo vo = new MenuVo();
        PTMenu e = this.menuDao.findById(id);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public MenuVo updateEntity(MenuVo vo) {
        PTMenu e = new PTMenu();
        BeanUtils.copyProperties((Object)vo, (Object)e);
        e = (PTMenu)this.menuDao.save(e);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public void deleteEntity(String id) {
        this.menuDao.delete((Serializable)((Object)id));
    }

    public List<MenuVal> getLeftMenuList() {
        List<MenuVo> nodes = this.findByParentId(this.getVirtualRoot().getId());
        ArrayList<MenuVal> menuList = new ArrayList<MenuVal>();
        if (!nodes.isEmpty()) {
            for (MenuVo i : nodes) {
                List<MenuVo> tmp = this.findByParentId(i.getId());
                menuList.add(new MenuVal(i, tmp));
            }
        }
        return menuList;
    }

    public List<MenuVal> getMenuList() {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sort"});
        Specification<PTMenu> spec = new Specification<PTMenu>(){
            List<Predicate> list = new ArrayList<Predicate>();

            public Predicate toPredicate(Root<PTMenu> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate p1 = cb.isNull((Expression)root.get("label"));
                Predicate p2 = cb.equal(root.get("label").as(String.class), (Object)"");
                this.list.add(cb.or((Expression)p2, (Expression)p1));
                this.list.add(cb.and(new Predicate[]{cb.equal(root.get("tenantId").as(String.class), (Object)InvocationInfoProxy.getTenantid())}));
                Predicate[] predicates = new Predicate[this.list.size()];
                query.where(this.list.toArray(predicates));
                return query.getRestriction();
            }
        };
        List nodes = this.menuDao.findAll((Specification)spec, sort);
        ArrayList<MenuVal> menuList = new ArrayList<MenuVal>();
        String parentId = this.getVirtualRoot().getId();
        ArrayList<MenuVo> tmp = null;
        MenuVo v1 = null;
        if (!nodes.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!parentId.equals(((PTMenu)nodes.get(i)).getParentId())) continue;
                tmp = new ArrayList<MenuVo>();
                v1 = new MenuVo();
                BeanUtils.copyProperties(nodes.get(i), (Object)v1);
                MenuVo v2 = null;
                for (int j = 0; j < nodes.size(); ++j) {
                    if (!((PTMenu)nodes.get(i)).getId().equals(((PTMenu)nodes.get(j)).getParentId())) continue;
                    v2 = new MenuVo();
                    BeanUtils.copyProperties(nodes.get(j), (Object)v2);
                    tmp.add(v2);
                }
                menuList.add(new MenuVal(v1, tmp));
            }
        }
        return menuList;
    }

    private Map<String, List<PTMenu>> getTreeMap(String rootId) {
        JSONObject json;
        JSONObject userjson;
        LinkedHashMap<String, List<PTMenu>> meunMap = new LinkedHashMap<String, List<PTMenu>>();
        List<PTMenu> meunList = this.getAllList(rootId);
        String uname = InvocationInfoProxy.getUserid();
        boolean isAdmin = false;
        String isSso = IntegrationVerifyUtils.isSsoVerify();
        if (Boolean.valueOf(isSso).booleanValue() && "1".equals((userjson = (JSONObject)(json = JSONObject.fromObject((Object)UserCenter.getUserById((String)uname))).get("user")).get("typeId").toString())) {
            isAdmin = true;
        }
        if (!meunList.isEmpty()) {
            for (PTMenu menu : meunList) {
                if (!isAdmin && !"Y".equalsIgnoreCase(menu.getIsVirtualNode()) && !"index".equals(menu.getFuncId()) || menu == null || menu.getParentId() == null) continue;
                ArrayList<PTMenu> l = (ArrayList<PTMenu>)meunMap.get(menu.getParentId());
                if (l == null) {
                    l = new ArrayList<PTMenu>();
                    meunMap.put(menu.getParentId(), l);
                }
                l.add(menu);
            }
        }
        return meunMap;
    }

    public List<MenuVo> findByFuncIdAndTenantId(String funcId, String tenantId) {
        List<PTMenu> list = this.menuDao.findByFuncIdAndTenantId(funcId, tenantId);
        ArrayList<MenuVo> vos = new ArrayList<MenuVo>();
        for (PTMenu e : list) {
            MenuVo v = new MenuVo();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    @Transactional
    public MenuVo updatePTMenu(MenuVo vo) {
        this.menuDao.updatePTMenu(vo.getName(), vo.getFuncId(), vo.getIcon(), vo.getIsVirtualNode(), vo.getLayoutId(), vo.getSort(), vo.getParentId(), vo.getId());
        PTMenu e = this.menuDao.findById(vo.getId());
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public MenuVo getFirstParentId(String parentid) {
        MenuVo vo = new MenuVo();
        PTMenu e = this.menuDao.getFirstParentId(parentid);
        if (e != null) {
            BeanUtils.copyProperties((Object)e, (Object)vo);
        }
        return vo;
    }

    public SidebarMenu listBarTree(String userId, String roleId) throws Exception {
        MenuVo root = this.getVirtualRoot();
        Map<String, List<MenuVo>> mapList = this.getPermissionTreeMap(userId, roleId, root.getId());
        Map<String, AppVO> appsMap = this.getAppsMap();
        SidebarMenu tree = this.getChildrensTree(root, mapList, appsMap);
        return tree;
    }

    public MenuVo getVirtualRoot() {
        PTMenu ptMenu = this.menuDao.getVirtualRoot();
        MenuVo menuVo = new MenuVo();
        if (ptMenu != null) {
            BeanUtils.copyProperties((Object)ptMenu, (Object)menuVo);
        }
        return menuVo;
    }

    private Map<String, List<MenuVo>> getPermissionTreeMap(String userId, String roleId, String rootId) throws Exception {
        LinkedHashMap<String, List<MenuVo>> meunMap = new LinkedHashMap<String, List<MenuVo>>();
        List<PTMenu> meunList = this.menuDao.findAllMenu();
        UserBaseVO userBaseVo = this.userService.findUserById(userId);
        boolean isAdmin = false;
        if (1 == userBaseVo.getTypeId()) {
            isAdmin = true;
        }
        Map<String, AppVO> authAppMap = this.getAuthApp(roleId);
        if (!meunList.isEmpty()) {
            for (PTMenu menu : meunList) {
                if (!isAdmin && !"Y".equalsIgnoreCase(menu.getIsVirtualNode()) && !authAppMap.containsKey(menu.getLayoutId()) && !"index".equals(menu.getFuncId()) || menu == null || menu.getParentId() == null) continue;
                ArrayList<MenuVo> l = (ArrayList<MenuVo>)meunMap.get(menu.getParentId());
                if (l == null) {
                    l = new ArrayList<MenuVo>();
                    meunMap.put(menu.getParentId(), l);
                }
                MenuVo menuVo = new MenuVo();
                BeanUtils.copyProperties((Object)menu, (Object)menuVo);
                l.add(menuVo);
            }
        }
        return meunMap;
    }

    public Map<String, AppVO> getAuthApp(String roleId) throws Exception {
        HashMap<String, AppVO> authAppMap = new HashMap<String, AppVO>();
        List appList = this.appService.getAppListByRoleId(roleId);
        if (!appList.isEmpty()) {
            for (AppVO app : appList) {
                authAppMap.put(app.getCode(), app);
            }
        }
        return authAppMap;
    }

    private Map<String, AppVO> getAppsMap() throws Exception {
        List apps = this.appService.getAllApps();
        HashMap<String, AppVO> appsMap = new HashMap<String, AppVO>();
        if (!apps.isEmpty()) {
            for (AppVO app : apps) {
                appsMap.put(app.getCode(), app);
            }
        }
        return appsMap;
    }

    private SidebarMenu getChildrensTree(MenuVo root, Map<String, List<MenuVo>> mapList, Map<String, AppVO> appsMap) throws Exception {
        SidebarMenu menu = this.adapedMenu(root, appsMap);
        List<MenuVo> nodes = mapList.get(root.getId());
        if (nodes != null && !nodes.isEmpty()) {
            ArrayList<SidebarMenu> childrenList = new ArrayList<SidebarMenu>();
            MenuCompartor mc = new MenuCompartor();
            Collections.sort(nodes, mc);
            for (MenuVo i : nodes) {
                SidebarMenu child = this.getChildrensTree(i, mapList, appsMap);
                if (child == null) continue;
                childrenList.add(child);
            }
            if ("Y".equalsIgnoreCase(root.getIsVirtualNode()) && childrenList.size() == 0) {
                return null;
            }
            menu.setChildren(childrenList);
            return menu;
        }
        if ("Y".equalsIgnoreCase(root.getIsVirtualNode())) {
            return null;
        }
        return menu;
    }

    private SidebarMenu adapedMenu(MenuVo root, Map<String, AppVO> appsMap) throws Exception {
        SidebarMenu sidebar = new SidebarMenu();
        AppVO app = appsMap.get(root.getLayoutId());
        if (app != null) {
            sidebar.setLocation(app.getProjectUrl());
            sidebar.setUrltype(app.getLinkType());
        } else {
            sidebar.setLocation(root.getLayoutId());
        }
        sidebar.setName(root.getName());
        sidebar.setMenustatus(root.getIsenable());
        sidebar.setIcon(root.getIcon());
        sidebar.setOpenview(root.getOpenview());
        sidebar.setTarget("workbench");
        sidebar.setId(root.getLayoutId());
        return sidebar;
    }

    public List<MenuVo> findByFuncIdNotId(String funcId, String id) {
        List<PTMenu> list = this.menuDao.findByFuncIdNotId(funcId, id);
        ArrayList<MenuVo> vos = new ArrayList<MenuVo>();
        for (PTMenu e : list) {
            MenuVo v = new MenuVo();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<MenuVal> getManagerMenu() throws Exception {
        return this.getMenuVal();
    }

    public List<MenuVal> getMenuVal() throws Exception {
        ArrayList<MenuVal> menuList;
        block8: {
            List<PTMenu> allNodes;
            List<MenuVo> nodes;
            block7: {
                String isSso = IntegrationVerifyUtils.isSsoVerify();
                String userId = InvocationInfoProxy.getUserid();
                UserBaseVO userBaseVo = this.userService.findUserById(userId);
                nodes = this.findByParentIdVal(this.getVirtualRoot().getId());
                allNodes = this.menuDao.findAllMenuVal();
                menuList = new ArrayList<MenuVal>();
                System.out.println("++++++++++1111111111+++++++++++++++++++++");
                if (!Boolean.valueOf(isSso).booleanValue()) break block7;
                if (1 != userBaseVo.getTypeId() || nodes.isEmpty()) break block8;
                for (MenuVo i : nodes) {
                    System.out.println("++++++++++++label=" + i.getLabel());
                    if (i.getLabel() == null || !"1".equals(i.getLabel())) continue;
                    ArrayList<MenuVo> tmp = new ArrayList<MenuVo>();
                    for (PTMenu c : allNodes) {
                        if (!i.getId().equals(c.getParentId()) || !"Y".equals(c.getIsvisible()) || !"Y".equals(c.getIsenable()) || (c.getLabel() == null || !"1".equals(c.getLabel())) && !"common".equals(c.getLabel())) continue;
                        MenuVo menuVo = new MenuVo();
                        BeanUtils.copyProperties((Object)c, (Object)menuVo);
                        AppVO appVo = this.appService.findAppByCode(c.getLayoutId(), tenantId);
                        if (appVo != null) {
                            menuVo.setLocation(appVo.getProjectUrl());
                        }
                        tmp.add(menuVo);
                    }
                    Collections.sort(tmp, new MenuCompartor());
                    menuList.add(new MenuVal(i, tmp));
                }
                break block8;
            }
            if (!nodes.isEmpty()) {
                for (MenuVo i : nodes) {
                    if (i.getLabel() == null || !"1".equals(i.getLabel())) continue;
                    System.out.println("++++++++++++label=" + i.getLabel());
                    ArrayList<MenuVo> tmp = new ArrayList<MenuVo>();
                    for (PTMenu c : allNodes) {
                        if (!i.getId().equals(c.getParentId()) || !"Y".equals(c.getIsvisible()) || !"Y".equals(c.getIsenable()) || (c.getLabel() == null || !"1".equals(c.getLabel())) && !"common".equals(c.getLabel())) continue;
                        MenuVo menuVo = new MenuVo();
                        BeanUtils.copyProperties((Object)c, (Object)menuVo);
                        AppVO appVo = this.appService.findAppByCode(c.getLayoutId(), tenantId);
                        if (appVo != null) {
                            menuVo.setLocation(appVo.getProjectUrl());
                        }
                        tmp.add(menuVo);
                    }
                    Collections.sort(tmp, new MenuCompartor());
                    menuList.add(new MenuVal(i, tmp));
                }
            }
        }
        return menuList;
    }
}

