/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.menu.web;

import com.yyjz.icop.menu.service.IPTMenuService;
import com.yyjz.icop.menu.vo.MenuVo;
import com.yyjz.icop.menu.vo.SidebarMenu;
import com.yyjz.icop.menu.web.bo.MenuBo;
import com.yyjz.icop.utils.CommonUtils;
import com.yyjz.icop.utils.WBStringUtil;
import iuap.portal.web.BaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.StaleObjectStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ptmenu"})
public class PTMenuController
extends BaseController {
    private Logger log = LoggerFactory.getLogger(PTMenuController.class);
    @Autowired
    private IPTMenuService menuService;

    @RequestMapping(value={"/allList"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> allList() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List data = this.menuService.listAllTree();
            results.put("code", "success");
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            results.put("data", data);
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/leftList"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> leftList() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List data = this.menuService.getLeftMenuList();
            results.put("code", "success");
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            results.put("data", data);
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/treeList"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> treeList() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List data = this.menuService.getMenuList();
            results.put("code", "success");
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            results.put("data", data);
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/getInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getNodeInfo(@RequestParam(required=true, value="id") String id) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            MenuVo vo = new MenuVo();
            MenuVo parent = new MenuVo();
            if (id != null && !"null".equals(id) && !"".equals(id)) {
                vo = this.menuService.findById(id);
                parent = this.menuService.findById(vo.getParentId());
            } else {
                parent = this.menuService.getVirtualRoot();
                vo = this.menuService.getFirstParentId(parent.getId());
            }
            MenuBo bo = new MenuBo();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)bo));
            bo.setParentName(parent.getName());
            results.put("data", (Object)bo);
            results.put("code", "success");
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> createNode(@RequestBody MenuVo vo) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List list = this.menuService.findByFuncIdAndTenantId(vo.getFuncId(), CommonUtils.getTenantId());
            if (list != null && list.size() > 0) {
                results.put("code", "failure");
                results.put("msg", "\u83dc\u5355\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
                return results;
            }
            if (vo.getSort() != null && vo.getSort().toString().length() > 0 && WBStringUtil.isInteger(vo.getSort().toString())) {
                vo.setSort(vo.getSort());
            } else {
                vo.setSort("0");
            }
            vo.setIsenable("Y");
            vo.setIsvisible("Y");
            vo.setTenantId(CommonUtils.getTenantId());
            vo = this.menuService.saveEntity(vo);
            results.put("data", vo);
            results.put("code", "success");
            results.put("msg", "\u65b0\u589e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u65b0\u589e\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> editNode(@RequestBody MenuVo vo) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            String parentId;
            List list;
            if (vo.getId() != null && (list = this.menuService.findByFuncIdNotId(vo.getFuncId(), vo.getId())) != null && list.size() > 0) {
                results.put("code", "failure");
                results.put("msg", "\u83dc\u5355\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
                return results;
            }
            List childs = this.menuService.getChildrenNodes(vo.getId());
            if (null != childs && !childs.isEmpty() && !(parentId = this.menuService.getVirtualRoot().getId()).equals(vo.getParentId())) {
                results.put("code", "failure");
                results.put("msg", "\u8be5\u83dc\u5355\u5df2\u62e5\u6709\u5b50\u83dc\u5355\uff0c\u7236\u83dc\u5355\u53ea\u80fd\u4e3a\u6839\u83dc\u5355(\u4e00\u7ea7\u83dc\u5355)\uff01");
                return results;
            }
            if (vo.getSort() != null && vo.getSort().toString().length() > 0 && WBStringUtil.isInteger(vo.getSort().toString())) {
                vo.setSort(vo.getSort());
            } else {
                vo.setSort("0");
            }
            vo = this.menuService.updatePTMenu(vo);
            results.put("data", vo);
            results.put("code", "success");
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (StaleObjectStateException e1) {
            results.put("code", "failure");
            results.put("msg", "\u5f53\u524d\u6570\u636e\u5df2\u88ab\u4ed6\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u91cd\u8bd5\u3002");
            this.log.error(e1.getMessage(), (Throwable)e1);
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/del"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> deleteNode(@RequestBody String id) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List list = this.menuService.findByParentId(this.getParameter("id"));
            if (list.size() > 0) {
                results.put("code", "failure");
                results.put("msg", "\u9519\u8bef\uff1a\u6b64\u8282\u70b9\u62e5\u6709\u5b50\u8282\u70b9\uff01");
                return results;
            }
            this.menuService.deleteEntity(this.getParameter("id"));
            results.put("code", "success");
            results.put("msg", "\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            results.put("code", "failure");
            results.put("msg", "\u5220\u9664\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/menuLeftList"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> queryManagerMenu(HttpServletRequest request) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            List data = this.menuService.getManagerMenu();
            results.put("status", 1);
            results.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            results.put("data", data);
        }
        catch (Exception e) {
            results.put("status", 0);
            results.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    @RequestMapping(value={"/sidebarList"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> sidebarList(HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            ArrayList<SidebarMenu> data = new ArrayList<SidebarMenu>();
            SidebarMenu sm = new SidebarMenu();
            sm.setIcon("icon-home");
            sm.setLocation("/home");
            sm.setName("\u9996\u9875");
            sm.setMenustatus("N");
            sm.setTarget("portal");
            sm.setUrltype("view");
            sm.setId("home");
            data.add(sm);
            resultMap.put("status", 1);
            resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            resultMap.put("data", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("status", 0);
            resultMap.put("msg", "\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01MSG:" + e.getMessage());
        }
        return resultMap;
    }
}

