/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.preferencemenu.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.context.bo.RoleBO;
import com.yyjz.icop.context.service.WorkbenchAppService;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.preferencemenu.bo.PreferenceMenuBO;
import com.yyjz.icop.preferencemenu.service.PreferenceMenuService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreferenceMenuServiceImpl
implements PreferenceMenuService {
    private static final String CURRENT_USER_ROLE_LIST = "CURRENT_USER_ROLE_LIST";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private RedisTemplate<String, Object> jdkRedisTemplate;
    @Autowired
    private WorkbenchAppService workbenchAppService;
    @Autowired
    private RoleService roleService;

    @Override
    public void save(String appId) {
        String userid = InvocationInfoProxy.getUserid();
        String delSQL = "DELETE from pt_preference_menu WHERE user_id = ? and app_id = ?";
        int update = this.jdbcTemplate.update(delSQL, new Object[]{userid, appId});
        if (update == 0) {
            String insertSQL = "INSERT INTO pt_preference_menu(`id`, `user_id`, `app_id`, order_num) VALUES (?, ?, ?,(SELECT ifnull(max(t.order_num), 0) from pt_preference_menu t WHERE t.user_id = ?) + 1)";
            this.jdbcTemplate.update(insertSQL, new Object[]{UUID.randomUUID().toString().replace("-", ""), userid, appId, userid});
        }
    }

    @Override
    public List<AppVO> loadUserPreferenceMenu(String roleId) {
        ArrayList<AppVO> results = new ArrayList<AppVO>();
        String userId = InvocationInfoProxy.getUserid();
        String sql = "SELECT t.app_id from pt_preference_menu t WHERE t.user_id = ? ORDER BY t.order_num desc";
        List appIds = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("app_id");
            }
        }, new Object[]{userId});
        List appVos = this.appService.getByIds(appIds);
        HashMap<String, AppVO> appMap = new HashMap<String, AppVO>();
        if (appVos != null && appVos.size() > 0) {
            for (int i = 0; i < appVos.size(); ++i) {
                AppVO appVO = (AppVO)appVos.get(i);
                appMap.put(appVO.getId(), appVO);
            }
        }
        List<Object> roleVoList = null;
        if (StringUtils.isBlank((CharSequence)roleId)) {
            roleVoList = (List)this.jdkRedisTemplate.opsForValue().get((Object)("CURRENT_USER_ROLE_LIST:" + userId));
            if (roleVoList == null || roleVoList.isEmpty()) {
                roleVoList = this.workbenchAppService.findRolesByUserId(userId);
            }
        } else {
            roleVoList = new ArrayList();
            RoleVO roleVo = this.roleService.findOneRole(roleId);
            RoleBO bo = new RoleBO();
            BeanUtils.copyProperties((Object)roleVo, (Object)((Object)bo));
            roleVoList.add((Object)bo);
        }
        if (roleVoList != null && roleVoList.size() > 0) {
            ArrayList<String> roleIds = new ArrayList<String>();
            for (int i = 0; i < roleVoList.size(); ++i) {
                roleIds.add(((RoleBO)((Object)roleVoList.get(i))).getId());
            }
            Map authAppMap = this.appMenuService.queryAuthAppList(roleIds);
            for (int i = 0; i < appIds.size(); ++i) {
                String appId = (String)appIds.get(i);
                AppVO appVO = (AppVO)appMap.get(appId);
                if (appVO == null || !authAppMap.containsKey(appVO.getPkAppMenu())) continue;
                results.add(appVO);
            }
        }
        return results;
    }

    @Override
    public void swapOrderNum(String fromAppId, String toAppId) {
        String userId = InvocationInfoProxy.getUserid();
        String sql = "SELECT t.id, t.app_id, t.order_num from pt_preference_menu t WHERE t.user_id = ? and (t.app_id=? or t.app_id=?)";
        List menuBOS = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<PreferenceMenuBO>(){

            public PreferenceMenuBO mapRow(ResultSet rs, int rowNum) throws SQLException {
                PreferenceMenuBO bo = new PreferenceMenuBO();
                bo.setId(rs.getString("id"));
                bo.setOrderNum(rs.getInt("order_num"));
                bo.setAppId(rs.getString("app_id"));
                return bo;
            }
        }, new Object[]{userId, fromAppId, toAppId});
        if (menuBOS.size() > 0) {
            PreferenceMenuBO fromBO = null;
            PreferenceMenuBO toBO = null;
            HashMap<String, PreferenceMenuBO> menuBOMap = new HashMap<String, PreferenceMenuBO>();
            for (PreferenceMenuBO bo : menuBOS) {
                menuBOMap.put(bo.getAppId(), bo);
            }
            fromBO = (PreferenceMenuBO)menuBOMap.get(fromAppId);
            toBO = (PreferenceMenuBO)menuBOMap.get(toAppId);
            String updateNumSQL = "UPDATE pt_preference_menu set order_num = ? WHERE id = ?";
            this.jdbcTemplate.update(updateNumSQL, new Object[]{toBO.getOrderNum(), fromBO.getId()});
            this.jdbcTemplate.update(updateNumSQL, new Object[]{fromBO.getOrderNum(), toBO.getId()});
        }
    }
}

