/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.shortcut.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.response.ListResponse;
import com.yyjz.icop.base.response.RefPagableResponse;
import com.yyjz.icop.shortcut.service.IShortcutCategoryService;
import com.yyjz.icop.shortcut.service.IShortcutService;
import com.yyjz.icop.shortcut.vo.ShortcutCategoryVO;
import iuap.portal.web.BaseController;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shortcutcategory"})
public class ShortcutCategoryController
extends BaseController {
    @Autowired
    private IShortcutCategoryService categoryService;
    @Autowired
    private IShortcutService shortcutService;

    @RequestMapping(method={RequestMethod.GET}, value={"/getAllCategory"})
    @ResponseBody
    public RefPagableResponse query() {
        List cs = this.categoryService.findAllCategory();
        RefPagableResponse ref = new RefPagableResponse(ShortcutCategoryVO.class);
        ref.setList(cs);
        return ref;
    }

    @RequestMapping(path={"selectListType"}, method={RequestMethod.GET})
    @ResponseBody
    public ListResponse<ShortcutCategoryVO> selectListType() {
        ListResponse result = new ListResponse();
        result.setList(this.categoryService.findAllCategory());
        result.setCode(true);
        result.setMsg("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    @RequestMapping(path={"shortcutAddGroup"}, method={RequestMethod.GET})
    @ResponseBody
    public String appAddGroup(ShortcutCategoryVO queryData) {
        JSONObject json = new JSONObject();
        try {
            ShortcutCategoryVO groupVO = new ShortcutCategoryVO();
            groupVO.setName(queryData.getName());
            groupVO.setCode(queryData.getCode());
            groupVO.setOrderNum(queryData.getOrderNum());
            groupVO = this.categoryService.saveShortcut(groupVO);
            json.put("success", (Object)true);
            json.put("message", (Object)"\u5feb\u6377\u94fe\u63a5\u5206\u7c7b\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            json.put("success", (Object)false);
            json.put("message", (Object)"\u5feb\u6377\u94fe\u63a5\u5206\u7c7b\u6dfb\u52a0\u5931\u8d25");
        }
        String str = json.toString();
        return str;
    }

    @RequestMapping(path={"delShortcutGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public String delShortcutGroup(ShortcutCategoryVO queryData) {
        JSONObject jsono = new JSONObject();
        try {
            this.shortcutService.deleteShortcutByGroup(queryData.getId());
            this.categoryService.delShortcutGroup(queryData.getId());
            jsono.put("success", (Object)true);
            jsono.put("message", (Object)"\u5feb\u6377\u94fe\u63a5\u5206\u7c7b\u5220\u9664\u6210\u529f");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            jsono.put("success", (Object)false);
            jsono.put("message", (Object)(ex.getMessage() != null && ex.getMessage().matches(".*[\u4e00-\u9fa5]+.*") ? ex.getMessage() : "\u5185\u90e8\u9519\u8bef"));
        }
        return jsono.toString();
    }

    @RequestMapping(path={"modifyAddGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyAddGroup(ShortcutCategoryVO queryData) {
        JSONObject jsono = new JSONObject();
        try {
            ShortcutCategoryVO groupVo = this.categoryService.findShortcutCategoryByID(queryData.getId());
            groupVo.setName(queryData.getName());
            groupVo.setOrderNum(queryData.getOrderNum());
            groupVo = this.categoryService.saveShortcut(groupVo);
            jsono.put("success", (Object)true);
            jsono.put("message", (Object)"\u5feb\u6377\u94fe\u63a5\u5206\u7c7b\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            jsono.put("success", (Object)false);
            jsono.put("message", (Object)"\u5185\u90e8\u9519\u8bef");
        }
        return jsono.toString();
    }

    @RequestMapping(value={"findById"}, method={RequestMethod.GET})
    @ResponseBody
    public String findById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return JSON.toJSONString((Object)false);
        }
        ShortcutCategoryVO groupVo = this.categoryService.findShortcutCategoryByID(id);
        return JSON.toJSONString((Object)groupVo);
    }
}

