/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.shortcut.web;

import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.RefPagableResponse;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.base.utils.QueryTool;
import com.yyjz.icop.shortcut.service.IShortcutService;
import com.yyjz.icop.shortcut.vo.ShortcutVO;
import com.yyjz.icop.utils.BeanUtils;
import iuap.portal.web.BaseController;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shortcut"})
public class ShortcutController
extends BaseController {
    @Autowired
    private IShortcutService shortcutService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/addShortcut"})
    public SimpleResponse addShortcut(@RequestBody ShortcutVO shortcut) throws JSONException {
        SimpleResponse sim = new SimpleResponse();
        try {
            int num = this.shortcutService.findShortcutByIdAndCode(shortcut.getId() == null ? "0" : shortcut.getId(), shortcut.getCode());
            if (num > 0) {
                sim.setMsg("\u7f16\u7801\u91cd\u590d");
                sim.setCode(false);
                return sim;
            }
            if (shortcut.getId() == null) {
                this.shortcutService.saveShortcut(shortcut);
                sim.setMsg("\u589e\u52a0\u6210\u529f");
            } else {
                ShortcutVO wd = this.shortcutService.findShortcutEntityByID(shortcut.getId());
                sim.setMsg("\u4fee\u6539\u6210\u529f");
                BeanUtils.copyProperties(shortcut, wd);
                this.shortcutService.saveShortcut(wd);
            }
            sim.setCode(true);
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            return sim;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/getShortcutByID"})
    public ObjectResponse<ShortcutVO> getShortcutByID(@RequestParam String shortcutId) throws JSONException {
        ObjectResponse sim = new ObjectResponse();
        try {
            ShortcutVO entity = this.shortcutService.findShortcutEntityByID(shortcutId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)entity);
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            return sim;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delShortcut"})
    @ResponseBody
    public SimpleResponse delShortcut(@RequestBody ShortcutVO shortcut) {
        SimpleResponse sim = new SimpleResponse();
        try {
            this.shortcutService.delShortcut(shortcut.getId());
            sim.setCode(true);
            sim.setMsg("\u5220\u9664\u6210\u529f");
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u5220\u9664\u5931\u8d25");
            return sim;
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/query"})
    @ResponseBody
    public RefPagableResponse query(@RequestParam(value="pageNumber", defaultValue="0") int pageNumber, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="categoryId", required=false) String categoryId, @RequestParam(value="relyCondition", required=false) String relyCondition) {
        PageRequest page = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        RefPagableResponse ref = new RefPagableResponse(ShortcutVO.class);
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        if (StringUtils.isNotBlank((CharSequence)categoryId)) {
            map.put("EQ_category", categoryId);
        }
        List vos = this.shortcutService.findShortcutPage(searchText, map, page);
        ref.setCode(true);
        ref.setMsg("\u67e5\u8be2\u6210\u529f");
        ref.setPageNumber(Integer.valueOf(pageNumber));
        ref.setPageSize(Integer.valueOf(pageSize));
        ref.setCount(Long.valueOf(this.shortcutService.findShortcutCount(searchText, map)));
        ref.setList(vos);
        return ref;
    }
}

