/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.widgetx.entity.UserWidgetEntity;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.UserWidgetDao;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.service.IUserWidgetService;
import com.yyjz.icop.widgetx.vo.UserWidgetVO;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="userWidgetService")
public class UserWidgetServiceImpl
implements IUserWidgetService {
    @Autowired
    private UserWidgetDao dao;
    @Autowired
    private WidgetXDao widgetXDao;

    public UserWidgetVO saveUserWidget(UserWidgetVO vo) throws Exception {
        try {
            UserWidgetEntity ue = new UserWidgetEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)ue));
            ue = (UserWidgetEntity)((Object)this.dao.save((Object)ue));
            BeanUtils.copyProperties((Object)((Object)ue), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return vo;
    }

    public void delUserWidget(String id) throws Exception {
        Assert.notNull((Object)id);
        this.dao.delete((Serializable)((Object)id));
    }

    public void delUserWidgetByUserId(String userId) throws Exception {
        Assert.notNull((Object)userId);
        Assert.notNull((Object)InvocationInfoProxy.getTenantid());
        this.dao.delUserWidgetByUserId(userId, InvocationInfoProxy.getTenantid());
    }

    public List<WidgetVO> findUserWidgetByUserId(String userId) {
        Assert.notNull((Object)userId);
        Assert.notNull((Object)InvocationInfoProxy.getTenantid());
        List<String> widgetIds = this.dao.findUserWidgetByUserId(userId, InvocationInfoProxy.getTenantid());
        if (widgetIds != null && widgetIds.size() > 0) {
            List<WidgetEntity> e = this.widgetXDao.findWidgetsByIds(widgetIds);
            ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
            for (WidgetEntity w : e) {
                WidgetVO vo = new WidgetVO();
                BeanUtils.copyProperties((Object)w, (Object)vo);
                vos.add(vo);
            }
            return vos;
        }
        return null;
    }
}

