/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.permission.app.service.IAppGroupService;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppGroupVO;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.service.IWidgetXApiService;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.service.BaseService;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import uap.web.utils.PropertyUtil;

@Service(value="widgetXApiService")
public class WidgetXApiServiceImpl
extends BaseService
implements IWidgetXApiService {
    @Autowired
    private WidgetXDao dao;
    @Autowired
    private IAppGroupService appGroupdao;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String ISTENANT = PropertyUtil.getPropertyByKey((String)"tenant.control");

    @Transactional
    public WidgetVO saveWidget(WidgetVO vo) throws Exception {
        WidgetEntity e = new WidgetEntity();
        int num = this.dao.findWidgetByIdAndCode(vo.getWidgetId() == null ? "0" : vo.getWidgetId(), vo.getId());
        if (num > 0) {
            throw new RuntimeException("\u5c0f\u90e8\u4ef6code\u91cd\u590d\uff1a" + vo.getId());
        }
        if (vo.getWidgetId() != null) {
            e = (WidgetEntity)this.dao.findOne((Serializable)((Object)vo.getWidgetId()));
        } else {
            BeanUtils.copyProperties((Object)vo, (Object)e);
        }
        if (StringUtils.isEmpty((String)e.getCategory())) {
            e.setCategory("workbench");
        }
        e = (WidgetEntity)this.dao.save(e);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    @Transactional
    public List<String> saveWidgets(List<WidgetVO> vos) throws Exception {
        ArrayList<WidgetEntity> list = new ArrayList<WidgetEntity>();
        ArrayList<AppVO> appList = new ArrayList<AppVO>();
        ArrayList<AppMenuVO> appMenuList_add = new ArrayList<AppMenuVO>();
        ArrayList<AppMenuVO> appMenuList_edit = new ArrayList<AppMenuVO>();
        ArrayList<String> list_err = new ArrayList<String>();
        AppVO app = null;
        AppMenuVO appMenuVo = null;
        WidgetEntity widget = null;
        String tenantId = InvocationInfoProxy.getTenantid();
        if ("1".equals(this.ISTENANT)) {
            tenantId = "global";
        }
        for (WidgetVO vo : vos) {
            AppMenuVO menu = this.appService.getAppMenuByCode(vo.getId());
            WidgetEntity widgetvo = this.dao.findWidgetByCode(vo.getId());
            AppVO appvo = this.appService.findAppByCode(vo.getId());
            AppGroupVO appGroup = this.appGroupdao.getOneAppGroup(vo.getCategory());
            if (appGroup == null) {
                list_err.add(vo.getId());
                continue;
            }
            String uuid = null;
            if (menu == null) {
                uuid = UUID.randomUUID().toString().replaceAll("-", "");
                appMenuVo = new AppMenuVO();
                appMenuVo.setId(uuid);
                appMenuVo.setAppType(Integer.parseInt(vo.getType()));
                appMenuVo.setName(vo.getName());
                appMenuVo.setCode(vo.getId());
                appMenuVo.setCategory(appGroup.getId());
                appMenuVo.setBelongStatus(Integer.parseInt(vo.getProperty()));
                appMenuVo.setAuth(vo.getAuth());
                appMenuVo.setTenantId(tenantId);
                appMenuVo.setIsAuthAble(Integer.valueOf(1));
                Integer order_num = this.appMenuService.findMinOrderNum(appGroup.getId());
                if (order_num == null) {
                    appMenuVo.setOrder_num(Integer.valueOf(1));
                } else {
                    appMenuVo.setOrder_num(Integer.valueOf(order_num - 1));
                }
                appMenuList_add.add(appMenuVo);
            } else {
                appMenuVo = menu;
                uuid = menu.getId();
                appMenuVo.setAppType(Integer.parseInt(vo.getType()));
                appMenuVo.setName(vo.getName());
                appMenuVo.setCode(vo.getId());
                appMenuVo.setCategory(appGroup.getId());
                appMenuVo.setBelongStatus(Integer.parseInt(vo.getProperty()));
                appMenuVo.setAuth(vo.getAuth());
                appMenuVo.setTenantId(tenantId);
                appMenuVo.setIsAuthAble(Integer.valueOf(1));
                appMenuList_edit.add(appMenuVo);
            }
            app = appvo == null ? new AppVO() : appvo;
            app.setGroupId(vo.getCategory());
            app.setCode(vo.getId());
            app.setWidgetCode(vo.getId());
            app.setProjectUrl(vo.getProjectUrl());
            app.setLinkType("url");
            app.setName(vo.getName());
            app.setBelongStatus(vo.getProperty());
            app.setAppType(vo.getType());
            app.setPkAppMenu(uuid);
            app.setTenantId(tenantId);
            appList.add(app);
            if (widgetvo == null) {
                widget = new WidgetEntity();
                BeanUtils.copyProperties((Object)vo, (Object)widget);
            } else {
                widget = widgetvo;
            }
            widget.setId(vo.getId());
            widget.setMagnetType(vo.getMagnetType());
            widget.setCategory(appGroup.getId());
            widget.setPkAppMenu(uuid);
            widget.setTenantId(tenantId);
            if (StringUtils.isBlank((String)widget.getUrlText())) {
                widget.setUrlText(widget.getUrl());
            }
            list.add(widget);
        }
        if (appMenuList_add.size() > 0) {
            this.appService.inserAppMenu(appMenuList_add);
        }
        if (appMenuList_edit.size() > 0) {
            this.appService.updateAppMenu(appMenuList_edit);
        }
        this.appService.saveApp(appList);
        this.dao.save(list);
        return list_err;
    }

    public List<WidgetVO> findWidgetsByIds(List<String> widgetIds) {
        List<WidgetEntity> list = this.dao.findWidgetsByIds(widgetIds);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (WidgetEntity e : list) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<WidgetVO> search(String word) {
        String tenantId = InvocationInfoProxy.getTenantid();
        List<Object> widgetVOS = new ArrayList<WidgetVO>();
        if (StringUtils.isNotBlank((String)word)) {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT ").append(" \tw.id, ").append(" \tw. NAME, ").append(" \tw.descr, ").append(" \tw.category, ").append(" \tw.wtype, ").append(" \tw.widget_type, ").append(" \tw.widget_property, ").append(" \tw.url, ").append(" \tw.pk_widget, ").append(" \tw.isenable, ").append(" \tw.system, ").append(" \tw.tenant, ").append(" \tw.ctime, ").append(" \tw.cnf, ").append(" \tw.modifytime, ").append(" \tw.setting, ").append(" \tw.ts, ").append(" \tw.dr, ").append(" \tw.tenant_id ").append(" FROM ").append(" \tpt_widget w ").append(" WHERE ").append(" \tw.dr = 0 ").append(" AND ( w.`name` LIKE concat('%', ?, '%') ").append(" OR w.id like concat('%', ?, '%')) ");
            widgetVOS = this.jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<WidgetVO>(){

                public WidgetVO mapRow(ResultSet resultSet, int i) throws SQLException {
                    WidgetVO widgetVO = new WidgetVO();
                    widgetVO.setId(resultSet.getString("id"));
                    widgetVO.setName(resultSet.getString("name"));
                    widgetVO.setWidgetId(resultSet.getString("pk_widget"));
                    widgetVO.setCategory(resultSet.getString("category"));
                    return widgetVO;
                }
            }, new Object[]{word, word});
        }
        return widgetVOS;
    }

    public List<WidgetVO> queryByIds(Collection<String> ids) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" \tw.id, ").append(" \tw. NAME, ").append(" \tw.descr, ").append(" \tw.category, ").append(" \tw.wtype, ").append(" \tw.widget_type, ").append(" \tw.widget_property, ").append(" \tw.url, ").append(" \tw.pk_widget, ").append(" \tw.isenable, ").append(" \tw.system, ").append(" \tw.tenant, ").append(" \tw.ctime, ").append(" \tw.cnf, ").append(" \tw.modifytime, ").append(" \tw.setting, ").append(" \tw.ts, ").append(" \tw.dr, ").append(" \tw.tenant_id, ").append(" \tcat.`name` cat_name").append(" FROM ").append(" \tpt_widget w ").append(" LEFT JOIN pt_widget_category cat ON w.category = cat.id ").append(" WHERE ").append(" \tw.pk_widget in (:ids) ");
        params.addValue("ids", ids);
        return namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<WidgetVO>(){

            public WidgetVO mapRow(ResultSet resultSet, int i) throws SQLException {
                WidgetVO widgetVO = new WidgetVO();
                widgetVO.setId(resultSet.getString("id"));
                widgetVO.setName(resultSet.getString("name"));
                widgetVO.setWidgetId(resultSet.getString("pk_widget"));
                widgetVO.setCategory(resultSet.getString("category"));
                widgetVO.setCategoryName(resultSet.getString("cat_name"));
                return widgetVO;
            }
        });
    }

    public long countByPkAppMenu(String pkAppMenu) {
        return this.dao.countByPkAppMenu(pkAppMenu, InvocationInfoProxy.getTenantid());
    }

    public List<WidgetVO> queryByPkAppMenus(Collection<String> pkAppMenus) {
        List<WidgetEntity> entities = this.dao.findByPkAppMenus(pkAppMenus);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (int i = 0; i < entities.size(); ++i) {
            WidgetEntity widgetEntity = entities.get(i);
            WidgetVO vo = new WidgetVO();
            BeanUtils.copyProperties((Object)widgetEntity, (Object)vo);
            vos.add(vo);
        }
        return vos;
    }

    public void updateWidgetByAppMenu(String menuId, String category) {
        String tenantId = InvocationInfoProxy.getTenantid();
        if (tenantId == null) {
            throw new RuntimeException("TenantId is null");
        }
        List<WidgetEntity> list = this.dao.findByPkAppMenu(menuId, tenantId);
        if (list != null && list.size() > 0) {
            for (WidgetEntity entity : list) {
                entity.setCategory(category);
            }
        }
        this.dao.save(list);
    }

    public List<WidgetVO> queryByPkAppMenuIds(Set<String> appMenuIds) {
        List<WidgetEntity> entities = this.dao.queryByPkAppMenuIds(appMenuIds);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (int i = 0; i < entities.size(); ++i) {
            WidgetEntity widgetEntity = entities.get(i);
            WidgetVO vo = new WidgetVO();
            BeanUtils.copyProperties((Object)widgetEntity, (Object)vo);
            vos.add(vo);
        }
        return vos;
    }

    public WidgetVO findWidgetByCode(String widgetCode) {
        WidgetVO widgetVo = null;
        WidgetEntity entities = this.dao.findWidgetByCode(widgetCode);
        if (entities != null) {
            widgetVo = new WidgetVO();
            BeanUtils.copyProperties((Object)entities, (Object)widgetVo);
        }
        return widgetVo;
    }
}

