/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.base.response.RefPagableResponse;
import com.yyjz.icop.base.response.annotation.BackField;
import com.yyjz.icop.base.response.annotation.DisplayText;
import com.yyjz.icop.base.response.annotation.Hidden;
import com.yyjz.icop.carousel.entity.CarouselEntity;
import com.yyjz.icop.carousel.repository.CarouselDao;
import com.yyjz.icop.layout.service.ILayoutRoleDesignService;
import com.yyjz.icop.layout.vo.LayoutRoleVO;
import com.yyjz.icop.permission.app.service.IAppGroupService;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.widget.service.IRoleWidgetService;
import com.yyjz.icop.permission.widget.vo.RoleWidgetVO;
import com.yyjz.icop.widgetx.entity.WidgetDesignEntity;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetDesignDao;
import com.yyjz.icop.widgetx.repository.WidgetXCategoryDao;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.service.IWidgetXService;
import com.yyjz.icop.widgetx.service.impl.WidgetXSpecification;
import com.yyjz.icop.widgetx.vo.WidgetDesignVO;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import iuap.portal.service.BaseService;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import uap.web.utils.PropertyUtil;

@Service
public class WidgetXServiceImpl
extends BaseService
implements IWidgetXService {
    private static final String isPublic = PropertyUtil.getPropertyByKey((String)"ccs.cloud.status");
    @Autowired
    private WidgetXDao dao;
    @Autowired
    private WidgetXCategoryDao categorydao;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IRoleWidgetService roleWidgetService;
    @Autowired
    private ILayoutRoleDesignService layoutRoleDesignService;
    @Autowired
    private CarouselDao carouselDao;
    @Autowired
    private RoleService roleService;
    @Autowired
    private IAppService appService;
    @Autowired
    private WidgetDesignDao widgetDesignDao;
    private Configuration freeMarkerCfg = new Configuration(Configuration.VERSION_2_3_22);
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private IAppGroupService appGroupService;

    public WidgetXServiceImpl() throws IOException {
        ClassPathResource resource = new ClassPathResource("widget-tpl");
        this.freeMarkerCfg.setDirectoryForTemplateLoading(resource.getFile());
        this.freeMarkerCfg.setDefaultEncoding("UTF-8");
        this.freeMarkerCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freeMarkerCfg.setLogTemplateExceptions(false);
    }

    public List<WidgetVO> findWidgetPage(String searchText, Map<String, Object> rel, PageRequest page) {
        WidgetXSpecification spe = new WidgetXSpecification(searchText, rel);
        Page es = this.dao.findAll(spe, (Pageable)page);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (WidgetEntity e : es) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public long findWidgetCount(String searchText, Map<String, Object> rel) {
        WidgetXSpecification spe = new WidgetXSpecification(searchText, rel);
        return this.dao.count(spe);
    }

    @Transactional
    public WidgetVO saveWidget(WidgetVO vo) throws Exception {
        WidgetEntity e = new WidgetEntity();
        BeanUtils.copyProperties((Object)vo, (Object)e);
        String lunboAddress = PropertyUtil.getPropertyByKey((String)"servername");
        AppMenuVO appMenuVO = this.appMenuService.findByPk(vo.getPkAppMenu());
        e.setCategory(appMenuVO.getCategory());
        e.setType(appMenuVO.getAppType() + "");
        e.setProperty(appMenuVO.getBelongStatus() + "");
        e.setTenantId(InvocationInfoProxy.getTenantid());
        if ("url".equals(e.getWtype())) {
            e.setUrl(lunboAddress + "/icop-workbench/widgetx/load/url/" + e.getPkAppMenu());
        } else {
            e.setUrl(e.getUrlText());
            e.setHeight(300);
        }
        e = (WidgetEntity)this.dao.save(e);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        Boolean bl = this.appMenuService.authWidget(e.getWidgetId(), e.getPkAppMenu(), Integer.valueOf(1));
        return vo;
    }

    public WidgetVO findWidgetEntityByID(String id) {
        WidgetEntity e = (WidgetEntity)this.dao.findOne((Serializable)((Object)id));
        WidgetVO vo = new WidgetVO();
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public int findWidgetByIdAndCode(String widgetId, String code) {
        return this.dao.findWidgetByIdAndCode(widgetId, code);
    }

    public boolean queryHasUsedLayout(String widgetId) {
        List<String> hasUsedLayout = this.dao.getUsedLayouts(widgetId);
        return hasUsedLayout != null && hasUsedLayout.size() > 0;
    }

    @Transactional
    public int delWidgetx(String widgetId) throws Exception {
        Boolean bl = this.appMenuService.authWidget(widgetId, null, Integer.valueOf(2));
        return this.dao.delWidgetx(widgetId);
    }

    private String getWidgetIds(String roleId) {
        StringBuffer sqlBf = new StringBuffer("");
        String widgetIds = "''";
        List layoutRoleList = this.roleWidgetService.findAllRoleWidgets(roleId);
        if (layoutRoleList != null && layoutRoleList.size() > 0) {
            for (RoleWidgetVO widgetVo : layoutRoleList) {
                sqlBf.append("'").append(widgetVo.getWidgetId()).append("',");
            }
            if (StringUtils.isNotEmpty((String)sqlBf.toString())) {
                widgetIds = sqlBf.substring(0, sqlBf.length() - 1);
            }
        }
        return widgetIds;
    }

    private String getWidgetIds() {
        StringBuffer sqlBf = new StringBuffer("");
        String widgetIds = "";
        List layoutRoleList = this.roleWidgetService.findAllWidgets();
        if (layoutRoleList != null && layoutRoleList.size() > 0) {
            for (RoleWidgetVO widgetVo : layoutRoleList) {
                sqlBf.append("'").append(widgetVo.getWidgetId()).append("',");
            }
            if (StringUtils.isNotEmpty((String)sqlBf.toString())) {
                widgetIds = sqlBf.substring(0, sqlBf.length() - 1);
            }
        }
        return widgetIds;
    }

    public WidgetVO[] queryWidgets(String roleid, String layoutId, String categoryId, String keyword) throws Exception {
        String widgetIds = null;
        List<CarouselEntity> carouselEntities = null;
        ArrayList<String> pkAppMenuIds = new ArrayList<String>();
        if (StringUtils.isEmpty((String)roleid)) {
            LayoutRoleVO layoutRoleVo = this.layoutRoleDesignService.queryParentLayRoleDesign(layoutId);
            if (layoutRoleVo != null) {
                widgetIds = this.getWidgetIds(layoutRoleVo.getRoleId());
                roleid = layoutRoleVo.getRoleId();
            }
            carouselEntities = this.carouselDao.findCarouselByRoleId(roleid, InvocationInfoProxy.getTenantid());
        } else {
            widgetIds = this.getWidgetIds(roleid);
        }
        List appMenuIDs = this.appMenuService.findAppMenuNotAuthByRoleId(roleid);
        List<String> appWidgetIDs = null;
        if (appMenuIDs != null && !appMenuIDs.isEmpty()) {
            appWidgetIDs = this.dao.findWidgetIdsByAppMenuIds(appMenuIDs);
        }
        if (appWidgetIDs != null && appWidgetIDs.size() > 0) {
            for (String widgetId : appWidgetIDs) {
                widgetIds = widgetIds + ",'" + widgetId + "'";
            }
        }
        if (StringUtils.isNotBlank((String)categoryId) && "all".equals(categoryId)) {
            categoryId = null;
        }
        if (StringUtils.isBlank((String)categoryId) && StringUtils.isBlank((String)keyword)) {
            List list = this.jdbcTemplate.query("SELECT o.id,o.name,o.descr,o.pk_app_menu,o.wtype,o.url,o.pk_widget as widgetId,o.isenable,o.system,o.tenant, o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id FROM pt_widget o where o.pk_widget in (" + widgetIds + ") order by o.ctime desc", (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
            List<WidgetVO> vos = new ArrayList<WidgetVO>();
            for (WidgetEntity e : list) {
                WidgetVO v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
            if (carouselEntities != null && carouselEntities.size() > 0) {
                vos = this.packageVos(vos, carouselEntities, null);
            }
            if (CollectionUtils.isNotEmpty(vos)) {
                this.loadWidgetCategory(vos, pkAppMenuIds);
            }
            return vos != null ? vos.toArray(new WidgetVO[0]) : null;
        }
        StringBuffer appMenuIdsStr = null;
        if (StringUtils.isNotBlank((String)categoryId)) {
            List<String> categorys = new ArrayList<String>();
            categorys.add(categoryId);
            categorys = this.appGroupService.getChildrenIdsByGroupIds(categorys);
            List appMenuIds = this.appMenuService.findAppMenuIdsByGroupIds(new HashSet(categorys));
            appMenuIdsStr = new StringBuffer();
            for (String id : appMenuIds) {
                appMenuIdsStr.append("'").append(id).append("',");
            }
            appMenuIdsStr.append("'-1'");
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT o.id,o.name,o.descr,o.pk_app_menu,o.wtype,o.url,o.pk_widget as widgetId,o.isenable,o.system,o.tenant,").append(" o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id from pt_widget o where o.pk_widget in (").append(widgetIds).append(") ");
        if (StringUtils.isNotBlank((String)categoryId)) {
            sql.append(" AND o.pk_app_menu in (").append(appMenuIdsStr).append(")");
        }
        if (StringUtils.isNotBlank((String)keyword)) {
            sql.append(" and o.name like ?");
            params.add(keyword);
        }
        sql.append(" AND o.dr = ? order by o.ctime desc");
        params.add(0);
        List list = this.jdbcTemplate.query(sql.toString(), params.toArray(), (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
        List<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (WidgetEntity e : list) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            if (StringUtils.isNotBlank((String)categoryId)) {
                v.setCategory(categoryId);
            }
            vos.add(v);
            pkAppMenuIds.add(v.getPkAppMenu());
        }
        if ("LB001".equals(categoryId)) {
            vos = this.packageVos(vos, carouselEntities, keyword);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            this.loadWidgetCategory(vos, pkAppMenuIds);
        }
        return vos != null ? vos.toArray(new WidgetVO[0]) : null;
    }

    public WidgetVO[] queryWidgets(String category, String keyword) throws Exception {
        String tenantId = InvocationInfoProxy.getTenantid();
        if ("public".equals(isPublic)) {
            tenantId = "global";
        }
        if (StringUtils.isNotBlank((String)category) && "all".equals(category)) {
            category = null;
        }
        StringBuffer appMenuIdsStr = null;
        if ("null".equals(category)) {
            category = null;
        }
        if (StringUtils.isNotBlank((String)category)) {
            List<String> categorys = new ArrayList<String>();
            categorys.add(category);
            categorys = this.appGroupService.getChildrenIdsByGroupIds(categorys);
            List appMenuIds = this.appMenuService.findAppMenuIdsByGroupIds(new HashSet(categorys));
            appMenuIdsStr = new StringBuffer();
            for (String id : appMenuIds) {
                appMenuIdsStr.append("'").append(id).append("',");
            }
            appMenuIdsStr.append("'-1'");
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT o.id,o.name,o.descr,o.pk_app_menu,o.wtype,o.url,o.pk_widget as widgetId,o.isenable,o.system,o.tenant,").append(" o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id from pt_widget o where 1=1 ");
        if (StringUtils.isNotBlank((String)category)) {
            sql.append(" AND o.pk_app_menu in (").append(appMenuIdsStr).append(")");
        }
        if (StringUtils.isNotBlank((String)keyword)) {
            sql.append(" and o.name like ?");
            params.add("%" + keyword + "%");
        }
        sql.append(" AND o.dr = ? order by o.ctime desc");
        params.add(0);
        List list = this.jdbcTemplate.query(sql.toString(), params.toArray(), (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (WidgetEntity e : list) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            if (StringUtils.isNotBlank((String)category)) {
                v.setCategory(category);
            }
            vos.add(v);
        }
        return vos.toArray(new WidgetVO[0]);
    }

    public void loadWidgetCategory(List<WidgetVO> vos, List<String> pkAppMenuIds) {
        Map appMenuVOs;
        if (CollectionUtils.isEmpty(pkAppMenuIds)) {
            for (WidgetVO vo : vos) {
                pkAppMenuIds.add(vo.getPkAppMenu());
            }
        }
        if (MapUtils.isNotEmpty((Map)(appMenuVOs = this.appMenuService.getAppMenuMapByIds(pkAppMenuIds)))) {
            for (WidgetVO v : vos) {
                if (null == appMenuVOs.get(v.getPkAppMenu())) continue;
                v.setCategory(((AppMenuVO)appMenuVOs.get(v.getPkAppMenu())).getCategory());
            }
        }
    }

    private List<WidgetVO> packageVos(List<WidgetVO> vos, List<CarouselEntity> carouselEntities, String keyword) {
        String lunboAddress = PropertyUtil.getPropertyByKey((String)"lunbo.url");
        if (StringUtils.isNotEmpty((String)keyword)) {
            for (CarouselEntity ce : carouselEntities) {
                if (!ce.getCarouselName().contains(keyword)) continue;
                WidgetVO v = new WidgetVO();
                v.setId(ce.getId());
                v.setName(ce.getCarouselName());
                v.setWidgetId(ce.getId());
                v.setUrl(lunboAddress + "/carousel/load/" + ce.getId());
                vos.add(v);
            }
        } else {
            for (CarouselEntity ce : carouselEntities) {
                WidgetVO v = new WidgetVO();
                v.setId(ce.getId());
                v.setName(ce.getCarouselName());
                v.setWidgetId(ce.getId());
                v.setUrl(lunboAddress + "/carousel/load/" + ce.getId());
                vos.add(v);
            }
        }
        return vos;
    }

    public List<WidgetVO> queryPermissionWidgetList(String roleId, String searchText) {
        String widgetIds = this.getWidgetIds(roleId);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        if (StringUtils.isNotEmpty((String)widgetIds)) {
            List list = null;
            list = StringUtils.isNotEmpty((String)searchText) ? this.jdbcTemplate.query("SELECT o.id,o.name,o.descr,'' as category,o.wtype,o.url,o.pk_widget as widgetId,o.isenable,o.system,o.tenant, o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id FROM pt_widget o where o.pk_widget in (" + widgetIds + ") and ( o.id like '%" + searchText + "%' or o.name like '%" + searchText + "%' ) order by o.ctime desc", (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class)) : this.jdbcTemplate.query("SELECT o.id,o.name,o.descr,'' as category,o.wtype,o.url,o.pk_widget as widgetId,o.isenable,o.system,o.tenant, o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id FROM pt_widget o where o.pk_widget in (" + widgetIds + ") order by o.ctime desc", (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
            for (WidgetEntity e : list) {
                WidgetVO v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
        }
        return vos;
    }

    public List<WidgetVO> queryWidgetxRefList(String searchText, String widgetProperty, String widgetType, int pageIndex, int pageSize) {
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        String sql = "select widgetenti0_.*  from pt_widget widgetenti0_   where ( widgetenti0_.widget_property='" + widgetProperty + "' or widgetenti0_.widget_property=0 )  and ( widgetenti0_.widget_type='" + widgetType + "' or widgetenti0_.widget_type=0 ) ";
        if (StringUtils.isNotEmpty((String)searchText)) {
            sql = sql + " and widgetenti0_.name like '%" + searchText + "%' ";
        }
        sql = sql + " and widgetenti0_.dr=0 limit " + pageIndex + "," + pageSize + " ";
        List list = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
        for (WidgetEntity e : list) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public void deleteWidgetxsByGroup(String category) {
        this.dao.deleteWidgetxsByGroup(category);
    }

    public void findAppWidget(String appId, Writer out) {
        AppVO app = this.appService.findOne(appId);
        WidgetDesignEntity widgetDesignEntity = this.widgetDesignDao.findByPkApp(appId);
        WidgetDesignVO widgetDesignVO = new WidgetDesignVO();
        BeanUtils.copyProperties((Object)((Object)widgetDesignEntity), (Object)widgetDesignVO);
        widgetDesignVO.setAppName(app.getName());
        widgetDesignVO.setAppDescription(app.getDescription());
        widgetDesignVO.setAppCode(app.getCode());
        widgetDesignVO.setAppLink(app.getProjectUrl());
        widgetDesignVO.setOpenMode(app.getOpenMode());
        if (StringUtils.isBlank((String)widgetDesignVO.getIcon())) {
            widgetDesignVO.setIcon("contract");
        }
        try {
            String templateFileName = "widget.ftlh";
            Template template = this.freeMarkerCfg.getTemplate(templateFileName);
            template.process((Object)widgetDesignVO, out);
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
        }
    }

    public void findAppUrlWidget(String pkAppMenu, Writer out) {
        List<WidgetEntity> wedget = this.dao.findByPkAppMenu(pkAppMenu);
        WidgetDesignVO widgetDesignVO = new WidgetDesignVO();
        if (wedget != null && wedget.size() > 0) {
            widgetDesignVO.setAppName(wedget.get(0).getName());
            widgetDesignVO.setAppLink(wedget.get(0).getUrlText());
            widgetDesignVO.setHeight(wedget.get(0).getHeight());
        }
        try {
            String templateFileName = "widget-url.ftlh";
            Template template = this.freeMarkerCfg.getTemplate(templateFileName);
            template.process((Object)widgetDesignVO, out);
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void saveAppWidget(WidgetDesignVO widgetDesignVO, String hostUrl) throws BusinessException {
        WidgetEntity widget;
        String tenantId = InvocationInfoProxy.getTenantid();
        if (tenantId == null) {
            throw new RuntimeException("TenantId is null");
        }
        AppVO app = this.appService.findOne(widgetDesignVO.getPkApp());
        String widgetCode = app.getWidgetCode();
        if (StringUtils.isNotBlank((String)widgetCode)) {
            widget = this.dao.findById(widgetCode);
            if (widget == null) {
                widget = new WidgetEntity();
            }
        } else {
            String appCode = app.getCode();
            WidgetEntity existWidget = this.dao.findById(appCode);
            if (existWidget != null) {
                throw new BusinessException("\u7cfb\u7edf\u4e2d\u5b58\u5728\u7f16\u53f7\u4e3a\u3010" + appCode + "\u3011\u7684\u5c0f\u90e8\u4ef6\uff0c\u8bf7\u5220\u9664\u540e\u518d\u751f\u6210\u5c0f\u90e8\u4ef6\u3002");
            }
            widget = new WidgetEntity();
        }
        widget.setId(app.getCode());
        widget.setName(app.getName());
        widget.setDescr(app.getDescription());
        widget.setCategory(app.getGroupId());
        widget.setWtype("xml");
        widget.setType(widgetDesignVO.getType());
        widget.setProperty(widgetDesignVO.getProperty());
        widget.setTenant(tenantId);
        widget.setDr(0);
        widget.setModifytime(new Date());
        widget.setPkAppMenu(app.getPkAppMenu());
        widget.setTenantId(InvocationInfoProxy.getTenantid());
        widget.setMagnetType("0");
        widget.setUrl("/icop-workbench/widgetx/load/" + widgetDesignVO.getPkApp());
        widget.setUrlText("/icop-workbench/widgetx/load/" + widgetDesignVO.getPkApp());
        this.dao.save(widget);
        Boolean bl = this.appMenuService.authWidget(widget.getWidgetId(), app.getPkAppMenu(), Integer.valueOf(1));
        app.setWidgetCode(widget.getId());
        this.appService.modify(app);
        WidgetDesignEntity widgetDesignEntity = new WidgetDesignEntity();
        BeanUtils.copyProperties((Object)widgetDesignVO, (Object)((Object)widgetDesignEntity));
        WidgetDesignEntity designEntity = this.widgetDesignDao.findByPkApp(widgetDesignVO.getPkApp());
        if (designEntity != null) {
            this.widgetDesignDao.delete((Object)designEntity);
        }
        this.widgetDesignDao.save((Object)widgetDesignEntity);
    }

    public List<WidgetVO> getRefreshWidetsByRoleId(String roleId) {
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        String tenantId = InvocationInfoProxy.getTenantid();
        List<WidgetEntity> list = this.dao.getRefreshWidgets(roleId, tenantId);
        if (list != null && list.size() > 0) {
            for (WidgetEntity e : list) {
                WidgetVO v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
        }
        return vos;
    }

    public List<WidgetVO> queryByPkAppMenu(String pkAppMenu) {
        List<WidgetEntity> widgetEntities = this.dao.findByPkAppMenu(pkAppMenu);
        ArrayList<WidgetVO> widgetVOS = new ArrayList<WidgetVO>();
        for (int i = 0; i < widgetEntities.size(); ++i) {
            WidgetEntity widgetEntity = widgetEntities.get(i);
            WidgetVO vo = new WidgetVO();
            BeanUtils.copyProperties((Object)widgetEntity, (Object)vo);
            widgetVOS.add(vo);
        }
        return widgetVOS;
    }

    public RefPagableResponse findNoPkAppMenuWidgets(int page, int pageSize, String word) {
        long total;
        List widgetRefVOS = new ArrayList();
        String countSQL = "SELECT count(*) from pt_widget t where t.pk_app_menu is null and t.dr = 0 ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)word)) {
            countSQL = countSQL + " AND (t.NAME like concat('%', ?, '%') OR t.ID LIKE  concat('%', ?, '%')) ";
            params.add(word);
            params.add(word);
        }
        if ((total = ((Long)this.jdbcTemplate.queryForObject(countSQL, Long.class, params.toArray())).longValue()) > 0L) {
            String sql = "SELECT pk_widget, id , name from pt_widget t where t.pk_app_menu is NULL AND  t.dr = 0 ";
            if (!params.isEmpty()) {
                sql = sql + " AND (t.NAME like concat('%', ?, '%') OR t.ID LIKE  concat('%', ?, '%'))";
            }
            int start = (page - 1) * pageSize;
            params.add(start);
            params.add(pageSize);
            sql = sql + " LIMIT ?,? ";
            widgetRefVOS = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<WidgetRefVO>(){

                public WidgetRefVO mapRow(ResultSet resultSet, int i) throws SQLException {
                    WidgetRefVO vo = new WidgetRefVO();
                    vo.setId(resultSet.getString("pk_widget"));
                    vo.setCode(resultSet.getString("id"));
                    vo.setName(resultSet.getString("name"));
                    return vo;
                }
            }, params.toArray());
        }
        RefPagableResponse refPagableResponse = new RefPagableResponse(WidgetRefVO.class);
        refPagableResponse.setList(widgetRefVOS);
        refPagableResponse.setCount(Long.valueOf(total));
        refPagableResponse.setPageNumber(Integer.valueOf(page));
        refPagableResponse.setPageSize(Integer.valueOf(pageSize));
        return refPagableResponse;
    }

    @Transactional
    public void linkWidgetToApp(String widgetId, String pkAppMenu) {
        String sql = "UPDATE pt_widget set pk_app_menu = ? WHERE pk_widget = ?";
        Boolean bl = this.appMenuService.authWidget(widgetId, pkAppMenu, Integer.valueOf(1));
        this.jdbcTemplate.update(sql, new Object[]{pkAppMenu, widgetId});
    }

    public WidgetVO[] queryAllWidgets(String layoutId, String categoryId, String keyword, String magnetType) {
        Object widgetIds = null;
        Object roleid = null;
        List<CarouselEntity> carouselEntities = null;
        if (StringUtils.isNotBlank((String)categoryId) && "all".equals(categoryId)) {
            categoryId = null;
        }
        if (StringUtils.isNotBlank((String)magnetType) && "all".equals(magnetType)) {
            magnetType = null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT o.id,o.name,o.descr,o.category,o.wtype,o.url,o.magnet_type,o.pk_widget as widgetId, ").append(" o.isenable,o.system,o.tenant,o.ctime,o.cnf,o.modifytime,o.setting,o.ts,o.dr,o.tenant_id ").append(" from pt_widget o ").append(" where o.dr=0 and o.tenant_id='" + InvocationInfoProxy.getTenantid() + "' ").append(" and o.pk_widget is not null ");
        if (StringUtils.isNotBlank((String)categoryId)) {
            sql.append(" and o.category='" + categoryId + "'");
        }
        if (StringUtils.isNotBlank((String)magnetType)) {
            sql.append(" and o.magnet_type='" + magnetType + "'");
        }
        if (StringUtils.isNotBlank((String)keyword)) {
            sql.append(" and o.name like '%" + keyword + "%'");
        }
        sql.append(" order by o.ctime desc");
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
        List<WidgetVO> vos = new ArrayList<WidgetVO>();
        for (WidgetEntity e : list) {
            WidgetVO v = new WidgetVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        if ("LB001".equals(categoryId)) {
            vos = this.packageVos(vos, carouselEntities, keyword);
        }
        return vos != null ? vos.toArray(new WidgetVO[0]) : null;
    }

    public List<WidgetVO> findWidgetAllPage(String searchText, String category, String magnetType, List<String> notIn, int startIndex, int pageSize) {
        StringBuilder sql = new StringBuilder();
        String tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, String> queryAppMenuParams = new HashMap<String, String>();
        if (null == tenantId) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4e0b\u6240\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u5c0f\u90e8\u4ef6\u5f02\u5e38\uff0ctenantId\u4e3anull!");
        }
        if (category.equals("all")) {
            category = null;
        }
        if (magnetType.equals("all")) {
            magnetType = null;
        }
        sql.append(" SElECT id,pk_widget,name,category,magnet_type from pt_widget where dr = 0 ");
        queryAppMenuParams.put("category", category);
        List appMenuIds = this.appMenuService.findAppMenuIdsByPropertiese(queryAppMenuParams);
        if (CollectionUtils.isNotEmpty((Collection)appMenuIds)) {
            sql.append(" AND pk_app_menu in ( ");
            for (String appMenuId : appMenuIds) {
                sql.append(" ?, ");
                params.add(appMenuId);
            }
        } else {
            return new ArrayList<WidgetVO>();
        }
        sql.append(" '0')");
        if (StringUtils.isNotBlank((String)magnetType)) {
            sql.append(" AND magnet_type = ?");
            params.add(magnetType);
        }
        if (CollectionUtils.isNotEmpty(notIn)) {
            sql.append(" AND pk_widget not in (");
            for (String id : notIn) {
                sql.append(" ?, ");
                params.add(id);
            }
            sql.append(" '0')");
        }
        if (StringUtils.isNotBlank((String)searchText)) {
            sql.append(" AND (name LIKE CONCAT('%', ?, '%') OR id LIKE CONCAT('%', ? ,'%')) ");
            params.add(searchText);
            params.add(searchText);
        }
        sql.append(" and pk_app_menu is not null ");
        sql.append(" order by category asc, id asc");
        sql.append(" LIMIT ?,?");
        params.add(startIndex);
        params.add(pageSize);
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<WidgetVO>(){

            public WidgetVO mapRow(ResultSet resultSet, int i) throws SQLException {
                WidgetVO vo = new WidgetVO();
                vo.setWidgetId(resultSet.getString("pk_widget"));
                vo.setId(resultSet.getString("id"));
                vo.setName(resultSet.getString("name"));
                vo.setCategory(resultSet.getString("category"));
                vo.setMagnetType(resultSet.getString("magnet_type"));
                return vo;
            }
        }, params.toArray());
    }

    public Long findWidgetAllCount(String searchText, String category, String magnetType, List<String> notIn) {
        StringBuilder sql = new StringBuilder();
        String tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<String> params = new ArrayList<String>();
        HashMap<String, String> queryAppMenuParams = new HashMap<String, String>();
        if (null == tenantId) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4e0b\u6240\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u5c0f\u90e8\u4ef6\u5f02\u5e38\uff0ctenantId\u4e3anull!");
        }
        if (category.equals("all")) {
            category = null;
        }
        if (magnetType.equals("all")) {
            magnetType = null;
        }
        sql.append(" SElECT COUNT(*) from pt_widget where dr = 0 ");
        queryAppMenuParams.put("category", category);
        List appMenuIds = this.appMenuService.findAppMenuIdsByPropertiese(queryAppMenuParams);
        if (CollectionUtils.isNotEmpty((Collection)appMenuIds)) {
            sql.append(" AND pk_app_menu in ( ");
            for (String appMenuId : appMenuIds) {
                sql.append(" ?, ");
                params.add(appMenuId);
            }
        } else {
            return 0L;
        }
        sql.append(" '0')");
        if (StringUtils.isNotBlank((String)magnetType)) {
            sql.append(" AND magnet_type = ?");
            params.add(magnetType);
        }
        if (CollectionUtils.isNotEmpty(notIn)) {
            sql.append(" AND pk_widget not in (");
            for (String id : notIn) {
                sql.append(" ?, ");
                params.add(id);
            }
            sql.append(" '0')");
        }
        if (StringUtils.isNotBlank((String)searchText)) {
            sql.append(" AND (name LIKE CONCAT('%', ?, '%') OR id LIKE CONCAT('%', ? ,'%')) ");
            params.add(searchText);
            params.add(searchText);
        }
        sql.append(" and pk_app_menu is not null ");
        return (Long)this.jdbcTemplate.queryForObject(sql.toString(), params.toArray(), Long.class);
    }

    public List<WidgetVO> findAllWithoutAuth() {
        List<WidgetEntity> entities;
        ArrayList<WidgetVO> resp = new ArrayList<WidgetVO>();
        String tenantId = InvocationInfoProxy.getTenantid();
        if (null == tenantId) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4e0b\u6240\u6709\u4e0d\u63a7\u6743\u5e94\u7528\u7684\u5c0f\u90e8\u4ef6\u5f02\u5e38\uff0ctenantId\u4e3anull!");
        }
        List appmenus = this.appMenuService.findAppMenuNotAuth();
        if (CollectionUtils.isNotEmpty((Collection)appmenus) && CollectionUtils.isNotEmpty(entities = this.dao.findByPkAppMenus(appmenus, tenantId))) {
            for (WidgetEntity e : entities) {
                WidgetVO v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                resp.add(v);
            }
        }
        return resp;
    }

    public List<WidgetVO> findWidgetByPkMenu(List<String> appMenuIdList) {
        ArrayList<WidgetVO> widgetList = new ArrayList<WidgetVO>();
        String appMenuIdString = "";
        for (String appMenuId : appMenuIdList) {
            appMenuIdString = appMenuIdString + "'" + appMenuId + "',";
        }
        appMenuIdString = appMenuIdString.substring(0, appMenuIdString.length() - 1);
        List widgetEntityList = this.jdbcTemplate.query("SELECT o.* FROM pt_widget o where o.pk_app_menu in (" + appMenuIdString + ") ", (RowMapper)BeanPropertyRowMapper.newInstance(WidgetEntity.class));
        if (widgetEntityList != null && widgetEntityList.size() > 0) {
            for (WidgetEntity widgetEntity : widgetEntityList) {
                WidgetVO widgetVo = new WidgetVO();
                BeanUtils.copyProperties((Object)widgetEntity, (Object)widgetVo);
                widgetList.add(widgetVo);
            }
        }
        return widgetList;
    }

    class WidgetRefVO {
        @Hidden
        @Column(name="id")
        private String id;
        @Column(name="code")
        @DisplayText(value="\u7f16\u7801")
        private String code;
        @BackField
        @Column(name="name")
        @DisplayText(value="\u540d\u79f0")
        private String name;

        WidgetRefVO() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

