/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.web;

import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.widgetx.service.IUserWidgetService;
import com.yyjz.icop.widgetx.vo.UserWidgetVO;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.web.BaseController;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/userWidget"})
public class UserWidgetController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(UserWidgetController.class);
    @Autowired
    private IUserWidgetService userWidgetService;

    @RequestMapping(path={"saveUserWidget"}, method={RequestMethod.POST})
    @ResponseBody
    public SimpleResponse saveUserWidget(@RequestBody UserWidgetVO vo) {
        LOG.debug(" UserWidgetVO:[{}]", (Object)vo.toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            vo = this.userWidgetService.saveUserWidget(vo);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"delUserWidget"}, method={RequestMethod.DELETE})
    @ResponseBody
    public SimpleResponse delUserWidgetById(@RequestBody UserWidgetVO vo) {
        LOG.debug(" UserWidgetVO:[{}]", (Object)vo.toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            if (vo.getId() != null) {
                this.userWidgetService.delUserWidget(vo.getId());
            } else if (vo.getUserId() != null) {
                this.userWidgetService.delUserWidgetByUserId(vo.getUserId());
            }
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"findUserWidgetByUserId"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<WidgetVO>> findUserWidgetByUserId(@RequestParam(value="userId", required=false) String userId) {
        LOG.debug(" userId:[{}]", (Object)userId);
        ObjectResponse sim = new ObjectResponse();
        try {
            List vos = this.userWidgetService.findUserWidgetByUserId(userId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)vos);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }
}

