/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.portal.base.web.Response;
import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.RefPagableResponse;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.base.response.annotation.BackField;
import com.yyjz.icop.base.response.annotation.DisplayText;
import com.yyjz.icop.base.response.annotation.Hidden;
import com.yyjz.icop.base.utils.QueryTool;
import com.yyjz.icop.base.vo.tree.MultipleTree;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.permission.app.service.IAppGroupService;
import com.yyjz.icop.permission.app.vo.AppGroupTreeVO;
import com.yyjz.icop.permission.app.vo.AppGroupVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.permission.widget.service.IRoleWidgetService;
import com.yyjz.icop.permission.widget.vo.RoleWidgetVO;
import com.yyjz.icop.utils.BeanUtils;
import com.yyjz.icop.widgetx.service.IWidgetXService;
import com.yyjz.icop.widgetx.vo.WidgetDesignVO;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import com.yyjz.icop.widgetx.web.bo.WidgetReferBO;
import iuap.portal.entity.WidgetCategoryVO;
import iuap.portal.web.BaseController;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/widgetx"})
public class WidgetXController
extends BaseController {
    @Autowired
    private IWidgetXService widgetXService;
    @Autowired
    private IRoleWidgetService roleWidgetService;
    @Autowired
    private ICarouselWidgetService carouselWidgetService;
    @Autowired
    private IAppGroupService appGroupService;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    RoleService roleService;

    @RequestMapping(method={RequestMethod.GET}, value={"/catels"})
    @ResponseBody
    public Object getWidgetCategory(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = new JSONObject();
        try {
            List appGroupList = this.appGroupService.getAllAppGroup();
            if (appGroupList != null && appGroupList.size() > 0) {
                WidgetCategoryVO[] widgets = new WidgetCategoryVO[appGroupList.size()];
                AppGroupVO appGroup = null;
                for (int i = 0; i < appGroupList.size(); ++i) {
                    appGroup = (AppGroupVO)appGroupList.get(i);
                    WidgetCategoryVO categoryVo = new WidgetCategoryVO();
                    categoryVo.setPkCategory(appGroup.getId());
                    categoryVo.setId(appGroup.getId());
                    categoryVo.setName(appGroup.getGroupName());
                    categoryVo.setSort(appGroup.getGroupOrder());
                    widgets[i] = categoryVo;
                }
                jsonObject.put("status", (Object)"1");
                jsonObject.put("data", (Object)widgets);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/addWidgetx"})
    public SimpleResponse addWidgetx(@RequestBody WidgetVO widget) throws JSONException {
        SimpleResponse sim = new SimpleResponse();
        try {
            int num = this.widgetXService.findWidgetByIdAndCode(widget.getWidgetId() == null ? "0" : widget.getWidgetId(), widget.getId());
            if (num > 0) {
                sim.setMsg("\u7f16\u7801\u91cd\u590d");
                sim.setCode(false);
                return sim;
            }
            if (widget.getWidgetId() == null) {
                widget.setWidgetId(UUID.randomUUID().toString());
                widget.setCtime(new Date());
                widget.setDr(0);
                if (StringUtils.isBlank((CharSequence)widget.getUrlText())) {
                    widget.setUrlText(widget.getUrl());
                }
                this.widgetXService.saveWidget(widget);
                sim.setMsg("\u589e\u52a0\u6210\u529f");
                this.appMenuService.changeAuthbleStatus(widget.getPkAppMenu(), false, 1);
            } else {
                WidgetVO wd = this.widgetXService.findWidgetEntityByID(widget.getWidgetId());
                widget.setModifytime(new Date());
                if (StringUtils.isBlank((CharSequence)widget.getUrlText())) {
                    widget.setUrlText(widget.getUrl());
                }
                sim.setMsg("\u4fee\u6539\u6210\u529f");
                BeanUtils.copyProperties(widget, wd);
                this.widgetXService.saveWidget(wd);
            }
            sim.setCode(true);
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            return sim;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/getWidgetxByID"})
    public ObjectResponse<WidgetVO> getWidgetxByID(@RequestParam String widgetId) throws JSONException {
        ObjectResponse sim = new ObjectResponse();
        try {
            WidgetVO entity = this.widgetXService.findWidgetEntityByID(widgetId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)entity);
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            return sim;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delWidgetx"})
    @ResponseBody
    public SimpleResponse delWidgetx(@RequestBody WidgetVO widget) {
        SimpleResponse sim = new SimpleResponse();
        try {
            WidgetVO entity = this.widgetXService.findWidgetEntityByID(widget.getWidgetId());
            String pkAppMenu = entity.getPkAppMenu();
            List rolesVos = this.roleService.getRolesByAppId(pkAppMenu);
            if (rolesVos != null && !rolesVos.isEmpty()) {
                sim.setCode(false);
                sim.setMsg("\u5e94\u7528\u5df2\u88ab:\u3010" + ((RoleVO)rolesVos.get(0)).getCompanyName() + "\u3011\u7ec4\u7ec7\u4e0b\u7684\u89d2\u8272:\u3010" + ((RoleVO)rolesVos.get(0)).getRoleName() + "\u3011\u5f15\u7528");
                return sim;
            }
            WidgetVO vo = this.widgetXService.findWidgetEntityByID(widget.getWidgetId());
            this.widgetXService.delWidgetx(widget.getWidgetId());
            if (null != vo && StringUtils.isNotBlank((CharSequence)vo.getPkAppMenu())) {
                this.appMenuService.changeAuthbleStatus(vo.getPkAppMenu(), true, 0);
            }
            sim.setCode(true);
            sim.setMsg("\u5220\u9664\u6210\u529f");
            return sim;
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u5220\u9664\u5931\u8d25");
            return sim;
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/query"})
    @ResponseBody
    public RefPagableResponse query(@RequestParam(value="pageNumber", defaultValue="0") int pageNumber, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="categoryId", required=false) String categoryId, @RequestParam(value="relyCondition", required=false) String relyCondition) {
        PageRequest page = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        RefPagableResponse ref = new RefPagableResponse(WidgetVO.class);
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        if (StringUtils.isNotBlank((CharSequence)categoryId)) {
            map.put("EQ_category", categoryId);
        }
        List vos = this.widgetXService.findWidgetPage(searchText, map, page);
        ref.setCode(true);
        ref.setMsg("\u67e5\u8be2\u6210\u529f");
        ref.setPageNumber(Integer.valueOf(pageNumber));
        ref.setPageSize(Integer.valueOf(pageSize));
        ref.setCount(Long.valueOf(this.widgetXService.findWidgetCount(searchText, map)));
        ref.setList(vos);
        return ref;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/queryAll"})
    @ResponseBody
    public Response query(HttpServletRequest request) {
        try {
            String roleid = null;
            String searchWidgetName = null;
            String layoutId = null;
            String keyword = null;
            String category = null;
            try {
                roleid = request.getParameter("roleid");
                searchWidgetName = request.getParameter("searchWidgetName");
                layoutId = this.getParameter("viewId");
                keyword = StringUtils.isNotEmpty((CharSequence)searchWidgetName) ? searchWidgetName : this.getParameter("keyword");
                category = this.getParameter("category");
            }
            catch (Exception e) {
                keyword = "";
                category = "";
            }
            WidgetVO[] widget = this.widgetXService.queryWidgets(roleid, layoutId, category, keyword);
            return this.success(null, widget);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.failure("");
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/queryAllWidgets"})
    @ResponseBody
    public Response queryAllWidgets(HttpServletRequest request) {
        try {
            String keyword = null;
            String category = null;
            keyword = this.getParameter("keyword");
            category = this.getParameter("category");
            WidgetVO[] widget = this.widgetXService.queryWidgets(category, keyword);
            return this.success(null, widget);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.failure("");
        }
    }

    @RequestMapping(value={"gridRef"}, method={RequestMethod.GET})
    @ResponseBody
    public RefPagableResponse widgetForRef(@RequestParam(required=true, value="pageNumber") int pageNumber, @RequestParam(required=true, value="pageSize") int pageSize, @RequestParam(required=false, value="relyCondition") String relyCondition, @RequestParam(required=false, value="searchText") String searchText) {
        RefPagableResponse response = new RefPagableResponse(WidgetRefVO.class);
        response.setPageNumber(Integer.valueOf(pageNumber - 1 < 0 ? 0 : pageNumber - 1));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest page = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        if (relyCondition.contains("and")) {
            String[] array = relyCondition.split("and");
            relyCondition = array[0].trim() + "&" + array[1].trim();
        }
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        try {
            Object obj;
            if (map != null && map.size() > 0 && (obj = map.get("EQ_roleId")) != null) {
                List vos = this.roleWidgetService.findAllRoleWidgets(obj.toString());
                ArrayList<String> ids = new ArrayList<String>();
                for (RoleWidgetVO v : vos) {
                    ids.add(v.getWidgetId());
                }
                if (ids.size() > 0) {
                    map.put("EQ_widgetIds", StringUtils.join((Object[])ids.toArray(), (String)","));
                }
            }
            ArrayList<WidgetRefVO> noRelationWidget = new ArrayList<WidgetRefVO>();
            List data = this.widgetXService.findWidgetPage(searchText, map, page);
            for (WidgetVO vo : data) {
                WidgetRefVO voList = new WidgetRefVO();
                voList.setId(vo.getWidgetId());
                voList.setCode(vo.getId());
                voList.setName(vo.getName());
                noRelationWidget.add(voList);
            }
            response.setCode(true);
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u6210\u529f\uff01");
            response.setCount(Long.valueOf(this.widgetXService.findWidgetCount(searchText, map)));
            response.setList(noRelationWidget);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            response.setCode(false);
            return response;
        }
        return response;
    }

    @RequestMapping(value={"carouselReferWidget"}, method={RequestMethod.GET})
    @ResponseBody
    public RefPagableResponse carouselReferWidget(@RequestParam(required=true, value="pageNumber") int pageNumber, @RequestParam(required=true, value="pageSize") int pageSize, @RequestParam(required=false, value="relyCondition") String relyCondition, @RequestParam(required=false, value="searchText") String searchText) {
        RefPagableResponse response = new RefPagableResponse(WidgetRefVO.class);
        response.setPageNumber(Integer.valueOf(pageNumber - 1 < 0 ? 0 : pageNumber - 1));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest page = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        try {
            if (map != null && map.size() > 0) {
                Object obj = map.get("EQ_roleId");
                ArrayList<WidgetReferBO> widgets = new ArrayList<WidgetReferBO>();
                if (obj != null && StringUtils.isNotBlank((CharSequence)obj.toString())) {
                    List vos = this.roleWidgetService.findAllRoleWidgets(obj.toString());
                    Object carouselId = map.get("EQ_carouselId");
                    List carWids = this.carouselWidgetService.findWidgetByCarouselId(carouselId.toString());
                    ArrayList<String> ids = new ArrayList<String>();
                    ArrayList<String> notIn = new ArrayList<String>();
                    for (WidgetVO v : carWids) {
                        notIn.add(v.getWidgetId());
                    }
                    if (notIn.size() > 0) {
                        map.put("EQ_widgetIds", StringUtils.join((Object[])notIn.toArray(), (String)","));
                    }
                    for (WidgetVO v : vos) {
                        ids.add(v.getWidgetId());
                    }
                    if (ids.size() > 0) {
                        map.put("EQ_roleWidgetIds", StringUtils.join((Object[])ids.toArray(), (String)","));
                    } else {
                        map.put("EQ_roleWidgetIds", "[\"\"]");
                    }
                    if (StringUtils.equals((CharSequence)"all", (CharSequence)String.valueOf(map.get("EQ_magnetType")))) {
                        map.remove("EQ_magnetType");
                    }
                    if (StringUtils.equals((CharSequence)"all", (CharSequence)String.valueOf(map.get("EQ_category")))) {
                        map.remove("EQ_category");
                    }
                    List data = this.widgetXService.findWidgetPage(searchText, map, page);
                    for (WidgetVO vo : data) {
                        WidgetReferBO voList = new WidgetReferBO();
                        voList.setId(vo.getWidgetId());
                        voList.setCode(vo.getId());
                        voList.setName(vo.getName());
                        voList.setCategory(vo.getCategory());
                        voList.setMagnetType(vo.getMagnetType());
                        widgets.add(voList);
                    }
                    response.setList(widgets);
                    response.setCount(Long.valueOf(this.widgetXService.findWidgetCount(searchText, map)));
                }
            }
            response.setCode(true);
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u5931\u8d25\uff01");
            response.setCode(false);
        }
        return response;
    }

    @RequestMapping(value={"carouselReferWidgetNew"}, method={RequestMethod.GET})
    @ResponseBody
    public RefPagableResponse carouselReferWidgetNew(@RequestParam(required=true, value="pageNumber") int pageNumber, @RequestParam(required=true, value="pageSize") int pageSize, @RequestParam(required=false, value="relyCondition") String relyCondition, @RequestParam(required=false, value="searchText") String searchText) {
        RefPagableResponse response = new RefPagableResponse(WidgetRefVO.class);
        response.setPageNumber(Integer.valueOf(pageNumber - 1 < 0 ? 0 : pageNumber - 1));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest page = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        try {
            if (map != null && map.size() > 0) {
                Object obj = map.get("EQ_roleId");
                List<Object> widgets = new ArrayList();
                if (obj != null && StringUtils.isNotBlank((CharSequence)obj.toString())) {
                    List vos = this.roleWidgetService.findAllRoleWidgets(obj.toString());
                    List widgetxWithoutAuth = this.widgetXService.findAllWithoutAuth();
                    Object carouselId = map.get("EQ_carouselId");
                    List carWids = this.carouselWidgetService.findWidgetByCarouselId(carouselId.toString());
                    ArrayList<String> ids = new ArrayList<String>();
                    ArrayList<String> notIn = new ArrayList<String>();
                    for (WidgetVO v : carWids) {
                        notIn.add(v.getWidgetId());
                    }
                    for (WidgetVO v : widgetxWithoutAuth) {
                        ids.add(v.getWidgetId());
                    }
                    if (notIn.size() > 0) {
                        map.put("EQ_widgetIds", StringUtils.join((Object[])notIn.toArray(), (String)","));
                    }
                    for (WidgetVO v : vos) {
                        ids.add(v.getWidgetId());
                    }
                    if (ids.size() > 0) {
                        map.put("EQ_roleWidgetIds", StringUtils.join((Object[])ids.toArray(), (String)","));
                    } else {
                        map.put("EQ_roleWidgetIds", "[\"\"]");
                    }
                    if (StringUtils.equals((CharSequence)"all", (CharSequence)String.valueOf(map.get("EQ_magnetType")))) {
                        map.remove("EQ_magnetType");
                    }
                    if (null != map.get("EQ_category")) {
                        if (!"all".equals(map.get("EQ_category").toString())) {
                            List<String> categorys = new ArrayList<String>();
                            categorys.add(map.get("EQ_category").toString());
                            categorys = this.appGroupService.getChildrenIdsByGroupIds(categorys);
                            List appMenuIds = this.appMenuService.findAppMenuIdsByGroupIds(new HashSet(categorys));
                            map.put("EQ_appMenuId", StringUtils.join((Object[])appMenuIds.toArray(), (String)","));
                        }
                        map.remove("EQ_category");
                    }
                    List data = this.widgetXService.findWidgetPage(searchText, map, page);
                    ArrayList<String> pkAppMenuIds = new ArrayList<String>();
                    for (WidgetVO vo : data) {
                        pkAppMenuIds.add(vo.getPkAppMenu());
                    }
                    widgets = this.loadWidgetCategory(data, pkAppMenuIds);
                    response.setList(widgets);
                    response.setCount(Long.valueOf(this.widgetXService.findWidgetCount(searchText, map)));
                }
            }
            response.setCode(true);
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u5931\u8d25\uff01");
            response.setCode(false);
        }
        return response;
    }

    public List<WidgetReferBO> loadWidgetCategory(List<WidgetVO> vos, List<String> pkAppMenuIds) {
        Map appMenuVOs = this.appMenuService.getAppMenuMapByIds(pkAppMenuIds);
        ArrayList<WidgetReferBO> resp = new ArrayList<WidgetReferBO>();
        if (MapUtils.isNotEmpty((Map)appMenuVOs)) {
            for (WidgetVO vo : vos) {
                if (null == appMenuVOs.get(vo.getPkAppMenu())) continue;
                WidgetReferBO voList = new WidgetReferBO();
                voList.setId(vo.getWidgetId());
                voList.setCode(vo.getId());
                voList.setName(vo.getName());
                voList.setCategory(((AppMenuVO)appMenuVOs.get(vo.getPkAppMenu())).getCategory());
                voList.setMagnetType(vo.getMagnetType());
                resp.add(voList);
            }
        }
        return resp;
    }

    @RequestMapping(value={"carouselAllReferWidget"}, method={RequestMethod.GET})
    @ResponseBody
    public RefPagableResponse carouselAllReferWidget(@RequestParam(required=true, value="pageNumber") int pageNumber, @RequestParam(required=true, value="pageSize") int pageSize, @RequestParam(required=false, value="relyCondition") String relyCondition, @RequestParam(required=false, value="searchText") String searchText) {
        RefPagableResponse response = new RefPagableResponse(WidgetRefVO.class);
        pageNumber = pageNumber - 1 < 0 ? 0 : pageNumber - 1;
        response.setPageNumber(Integer.valueOf(pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        Map map = QueryTool.parseCondition((String)relyCondition, (String[])new String[]{"&"});
        try {
            if (map != null && map.size() > 0) {
                String category = null != map.get("EQ_category") ? map.get("EQ_category").toString() : null;
                String magnetType = null != map.get("EQ_magnetType") ? map.get("EQ_magnetType").toString() : null;
                ArrayList<WidgetReferBO> widgets = new ArrayList<WidgetReferBO>();
                Object carouselId = map.get("EQ_carouselId");
                List carWids = this.carouselWidgetService.findWidgetByCarouselId(carouselId.toString());
                ArrayList<String> notIn = new ArrayList<String>();
                for (WidgetVO v : carWids) {
                    notIn.add(v.getWidgetId());
                }
                response.setCount(this.widgetXService.findWidgetAllCount(searchText, category, magnetType, notIn));
                List data = this.widgetXService.findWidgetAllPage(searchText, category, magnetType, notIn, pageNumber * pageSize, pageSize);
                for (WidgetVO vo : data) {
                    WidgetReferBO voList = new WidgetReferBO();
                    voList.setId(vo.getWidgetId());
                    voList.setCode(vo.getId());
                    voList.setName(vo.getName());
                    voList.setCategory(vo.getCategory());
                    voList.setMagnetType(vo.getMagnetType());
                    widgets.add(voList);
                }
                response.setList(widgets);
            }
            response.setCode(true);
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg("\u67e5\u8be2\u5c0f\u90e8\u4ef6\u5931\u8d25\uff01");
            response.setCode(false);
        }
        return response;
    }

    @RequestMapping(value={"getPermissionWidgetTree"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject getPermissionWidgetTree(@RequestParam String roleId, @RequestParam(required=false) String searchText) {
        JSONObject ret = new JSONObject();
        try {
            List resultList = this.widgetXService.queryPermissionWidgetList(roleId, searchText);
            JSONObject data = new JSONObject();
            data.put("listPermissionWidget", (Object)resultList);
            ret.put("code", (Object)ReturnCode.SUCCESS.getValue());
            ret.put("data", (Object)data);
            ret.put("msg", (Object)"\u83b7\u53d6\u5c0f\u90e8\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("code", (Object)ReturnCode.FAILURE.getValue());
            ret.put("msg", (Object)"\u83b7\u53d6\u5c0f\u90e8\u4ef6\u5931\u8d25");
        }
        return ret;
    }

    @RequestMapping(value={"load/{appId}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void loadWidget(@PathVariable(value="appId") String appId, HttpServletResponse response) {
        response.setContentType("application/xhtml+xml;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            this.widgetXService.findAppWidget(appId, (Writer)response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"load/url/{appMenuId}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void loadUrlWidget(@PathVariable(value="appMenuId") String appMenuId, HttpServletResponse response) {
        response.setContentType("application/xhtml+xml;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            this.widgetXService.findAppUrlWidget(appMenuId, (Writer)response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    @ResponseBody
    public SimpleResponse generateWidget(@RequestBody WidgetDesignVO widgetDesignVO, HttpServletRequest request) {
        SimpleResponse response = new SimpleResponse();
        try {
            StringBuffer requestURL = request.getRequestURL();
            String contextPath = request.getContextPath();
            int index = requestURL.indexOf(contextPath);
            String url = requestURL.substring(0, index) + contextPath;
            this.widgetXService.saveAppWidget(widgetDesignVO, url);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(false);
            response.setMsg(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"getRefreshWidgets"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject getRefreshWidgets(@RequestParam String roleId) {
        JSONObject ret = new JSONObject();
        try {
            List resultList = this.widgetXService.getRefreshWidetsByRoleId(roleId);
            JSONObject data = new JSONObject();
            data.put("listPermissionWidget", (Object)resultList);
            ret.put("code", (Object)ReturnCode.SUCCESS.getValue());
            ret.put("data", (Object)data);
            ret.put("msg", (Object)"\u83b7\u53d6\u5c0f\u90e8\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("code", (Object)ReturnCode.FAILURE.getValue());
            ret.put("msg", (Object)"\u83b7\u53d6\u5c0f\u90e8\u4ef6\u5931\u8d25");
        }
        return ret;
    }

    @RequestMapping(value={"queryByPkAppMenu"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<WidgetVO>> queryByPkAppMenu(@RequestParam String appMenuId) {
        ObjectResponse response = new ObjectResponse();
        try {
            List widgetVOS = this.widgetXService.queryByPkAppMenu(appMenuId);
            response.setData((Object)widgetVOS);
            response.setCode(true);
            response.setMsg("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(false);
            response.setMsg(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"noPkAppMenuWidgets"}, method={RequestMethod.GET})
    @ResponseBody
    public RefPagableResponse widgetForRef(@RequestParam(required=true, value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(required=true, value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="searchText") String searchText) {
        return this.widgetXService.findNoPkAppMenuWidgets(pageNumber, pageSize, searchText);
    }

    @RequestMapping(value={"linkWidgetToApp"}, method={RequestMethod.POST})
    @ResponseBody
    public SimpleResponse linkWidgetToApp(String widgetId, String pkAppMenu) {
        SimpleResponse simpleResponse = new SimpleResponse();
        try {
            this.widgetXService.linkWidgetToApp(widgetId, pkAppMenu);
            simpleResponse.setCode(true);
            simpleResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            simpleResponse.setCode(false);
            simpleResponse.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return simpleResponse;
    }

    @RequestMapping(path={"getAllAppGroupTree"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray getAllAppGroupTree(@RequestParam(required=false, value="param") String param) {
        ArrayList<AppGroupTreeVO> bos = new ArrayList<AppGroupTreeVO>();
        if (StringUtils.isBlank((CharSequence)param)) {
            AppGroupTreeVO searchAllNode = new AppGroupTreeVO();
            searchAllNode.setDr(0);
            searchAllNode.setGroupName("\u5168\u90e8\u5206\u7ec4");
            searchAllNode.setSelectable(true);
            searchAllNode.setInnercode("0000");
            AppGroupTreeVO carouselNode = new AppGroupTreeVO();
            carouselNode.setDr(0);
            carouselNode.setGroupName("\u8f6e\u64ad");
            carouselNode.setSelectable(true);
            carouselNode.setInnercode("9999");
            carouselNode.setId("LB001");
            bos.add(searchAllNode);
            bos.add(carouselNode);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)param)) {
            paramMap.put("searchText", param);
        }
        bos.addAll(this.appGroupService.getAllByProperties(paramMap));
        JSONArray jsonArray = new JSONArray();
        if (bos != null && bos.size() != 0) {
            String returnTree = MultipleTree.getTree(bos);
            jsonArray = JSON.parseArray((String)returnTree);
        }
        return jsonArray;
    }

    class WidgetRefVO {
        @Hidden
        @Column(name="id")
        private String id;
        @Column(name="code")
        @DisplayText(value="\u7f16\u7801")
        private String code;
        @BackField
        @Column(name="name")
        @DisplayText(value="\u540d\u79f0")
        private String name;

        WidgetRefVO() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

