/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.mapper.CheckMapper;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String CRG_PRO_CHECK = "CRG_PRO_CHECK";
    private static final String CRG_ORG_CHECK = "CRG_ORG_CHECK";
    private static final String ASSET_CODE = "ASSET_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<CheckVO> saveOrUpdate(CheckVO checkVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)checkVO.getBillCode())) {
            CommonResponse billCode = null;
            if (checkVO.getBelongType() == 0) {
                billCode = this.billCodeApi.getCodeBatchByRuleCode(CRG_PRO_CHECK, tenantId);
            }
            if (checkVO.getBelongType() == 1) {
                billCode = this.billCodeApi.getCodeBatchByRuleCode(CRG_ORG_CHECK, tenantId);
            }
            if (billCode.isSuccess()) {
                checkVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)checkVO, CheckEntity.class));
        List<CheckDetailEntity> checkDetail = entity.getCheckDetail();
        String materialName = "";
        int count = 0;
        ArrayList<String> materialNameList = new ArrayList<String>();
        if (checkDetail != null && checkDetail.size() > 0) {
            for (CheckDetailEntity checkDetailEntity : checkDetail) {
                if (null == checkDetailEntity.getAssetCode()) {
                    ++count;
                }
                if (materialNameList.contains(checkDetailEntity.getMaterialName())) continue;
                materialNameList.add(checkDetailEntity.getMaterialName());
            }
        }
        if (count > 0) {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId, count);
            List assetCodeList = (List)codeBatchByRuleCode.getData();
            block1: for (String code : assetCodeList) {
                for (CheckDetailEntity checkDetailEntity : checkDetail) {
                    if (null != checkDetailEntity.getAssetCode()) continue;
                    checkDetailEntity.setAssetCode(code);
                    checkDetailEntity.setAssetId(IdWorker.getId());
                    continue block1;
                }
            }
        }
        if (materialNameList != null && materialNameList.size() > 0) {
            for (String materialNames : materialNameList) {
                materialName = materialName + materialNames + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.checkService.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

