package com.ejianc.business.panhuo.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_goods")
public class GoodsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 资产编号
    @TableField(value="belong_type")
    private Integer belongType; // 类型 0=项目，1=公司
    @TableField(value="seller")
    private Long seller; // 发布人
    @TableField(value="seller_name")
    private String sellerName; // 发布人名称
    @TableField(value="tool_id")
    private Long toolId; // 机具主键
    @TableField(value="mainimg_path")
    private String mainimgPath; // 资产主图URL
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="belong_org_id")
    private Long belongOrgId; // 归属公司主键
    @TableField(value="belong_org_name")
    private String belongOrgName; // 归属公司名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编号
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资类别编号
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="asset_type")
    private Integer assetType; // 物资类型 0-周转材，1-台车
    @TableField(value="asset_code")
    private String assetCode; // 资产编码
    @TableField(value="asset_id")
    private Long assetId; // 物资主键
    @TableField(value="capacity")
    private java.math.BigDecimal capacity; // 承载量
    @TableField(value="asset_belong_type")
    private Integer assetBelongType; // 资产归属 0-项目，1-公司
    @TableField(value="recovery_type")
    private Integer recoveryType; // 回收类型 0-待指定回收 1-已指定回收  2-待公司回收
    @TableField(value="source_id")
    private String sourceId; // 物资来源ID
    @TableField(value="system_id")
    private Long systemId; // 所属系统ID
    @TableField(value="guide_price")
    private java.math.BigDecimal guidePrice; // 指导价格
    @TableField(value="site_nums")
    private java.math.BigDecimal siteNums; // 在场数量
    @TableField(value="originalprice")
    private java.math.BigDecimal originalprice; // 原价
    @TableField(value="discount")
    private java.math.BigDecimal discount; // 折扣
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="price")
    private java.math.BigDecimal price; // 单价
    @TableField(value="nums")
    private java.math.BigDecimal nums; // 数量
    @TableField(value="sell_nums")
    private java.math.BigDecimal sellNums; // 已成交数量
    @TableField(value="pre_nums")
    private java.math.BigDecimal preNums; // 预定中数量
    @TableField(value="rotatable_nums")
    private java.math.BigDecimal rotatableNums; // 可周转数量(上架-已成交-预定中)
    @TableField(value="remaining_nums")
    private java.math.BigDecimal remainingNums; // 剩余数量(上架-已成交)
    @TableField(value="is_pack")
    private String isPack; // 0-是  1-否
    @TableField(value="address_id")
    private Long addressId; // 地址主键
    @TableField(value="address_name")
    private String addressName; // 出售方
    @TableField(value="project_address")
    private String projectAddress; //
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="first_location")
    private String firstLocation; // 所在地一级区域
    @TableField(value="second_location")
    private String secondLocation; // 所在地二级区域
    @TableField(value="third_location")
    private String thirdLocation; // 所在地三级区域
    @TableField(value="fourth_location")
    private String fourthLocation; // 所在地四级区域
    @TableField(value="location")
    private String location; // 所在地末级区域
    @TableField(value="lon")
    private Double lon; // 经度
    @TableField(value="lat")
    private Double lat; // 纬度
    @TableField(value="phone")
    private String phone; // 联系方式
    @TableField(value="name")
    private java.lang.String name; // 联系人
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="shelf_time")
    private java.util.Date shelfTime; // 上架时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="lower_time")
    private java.util.Date lowerTime; // 下架时间
    @TableField(value="lower_type")
    private Integer lowerType; // 下架类型0-手动下架，1-售罄下架，2-回收下架
    @TableField(value="lower")
    private Long lower; // 下架人
    @TableField(value="details")
    private String details; // 资产详情
    @TableField(value="status")
    private Integer status; // 资产状态0-在售，1-下架，2-暂存，3-待回收，4-已回收
    @TableField(value="label_name")
    private java.lang.String labelName; // 标签名称
    @TableField(exist = false)
    private java.lang.String distance; // 距离
    @TableField(value="shelf_type")
    private java.lang.String shelfType; // 资产类型
    @TableField(value="type")
    private Integer type; // 0-手动上架，1-加工上架
    @TableField(value="order_id")
    private Long orderId; // 机具周转的订单主键
    @TableField(value="shelf_mny")
    private java.math.BigDecimal shelfMny; // 上架总金额
    @TableField(value="record_id")
    private Long recordId;//记录表ID --在场

    // 标签子表
    @TableField(exist = false)
    @SubEntity(serviceName="labeldetailService",pidName = "sourceId")
    private List<LabeldetailEntity> labels = new ArrayList<>();

    // 图片子表
    @TableField(exist = false)
    @SubEntity(serviceName="imgdetailService",pidName = "sourceId")
    private List<ImgdetailEntity> imgsPath = new ArrayList<>();

    public String getShelfType() {
        return shelfType;
    }

    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public List<LabeldetailEntity> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailEntity> labels) {
        this.labels = labels;
    }

    public List<ImgdetailEntity> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailEntity> imgsPath) {
        this.imgsPath = imgsPath;
    }

    /**
     * 资产编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 资产编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 类型 0=项目，1=公司
     */
    public Integer getBelongType() {
        return belongType;
    }

    /**
     * 类型 0=项目，1=公司
     */
    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }
    /**
     * 发布人
     */
    public Long getSeller() {
        return seller;
    }

    /**
     * 发布人
     */
    public void setSeller(Long seller) {
        this.seller = seller;
    }
    /**
     * 发布人名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * 发布人名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 机具主键
     */
    public Long getToolId() {
        return toolId;
    }

    /**
     * 机具主键
     */
    public void setToolId(Long toolId) {
        this.toolId = toolId;
    }
    /**
     * 资产主图URL
     */
    public String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 项目主键
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 归属公司主键
     */
    public Long getBelongOrgId() {
        return belongOrgId;
    }

    /**
     * 归属公司主键
     */
    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }
    /**
     * 归属公司名称
     */
    public String getBelongOrgName() {
        return belongOrgName;
    }

    /**
     * 归属公司名称
     */
    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编号
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编号
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别编号
     */
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    /**
     * 物资类别编号
     */
    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资类型 0-周转材，1-台车
     */
    public Integer getAssetType() {
        return assetType;
    }

    /**
     * 物资类型 0-周转材，1-台车
     */
    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }
    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 物资主键
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 物资主键
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 承载量
     */
    public java.math.BigDecimal getCapacity() {
        return capacity;
    }

    /**
     * 承载量
     */
    public void setCapacity(java.math.BigDecimal capacity) {
        this.capacity = capacity;
    }
    /**
     * 资产归属 0-项目，1-公司
     */
    public Integer getAssetBelongType() {
        return assetBelongType;
    }

    /**
     * 资产归属 0-项目，1-公司
     */
    public void setAssetBelongType(Integer assetBelongType) {
        this.assetBelongType = assetBelongType;
    }
    /**
     * 回收类型 0-待指定回收 1-已指定回收  2-待公司回收
     */
    public Integer getRecoveryType() {
        return recoveryType;
    }

    /**
     * 回收类型 0-待指定回收 1-已指定回收  2-待公司回收
     */
    public void setRecoveryType(Integer recoveryType) {
        this.recoveryType = recoveryType;
    }
    /**
     * 物资来源ID
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 物资来源ID
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 所属系统ID
     */
    public Long getSystemId() {
        return systemId;
    }

    /**
     * 所属系统ID
     */
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    /**
     * 指导价格
     */
    public java.math.BigDecimal getGuidePrice() {
        return guidePrice;
    }

    /**
     * 指导价格
     */
    public void setGuidePrice(java.math.BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }
    /**
     * 在场数量
     */
    public java.math.BigDecimal getSiteNums() {
        return siteNums;
    }

    /**
     * 在场数量
     */
    public void setSiteNums(java.math.BigDecimal siteNums) {
        this.siteNums = siteNums;
    }
    /**
     * 原价
     */
    public java.math.BigDecimal getOriginalprice() {
        return originalprice;
    }

    /**
     * 原价
     */
    public void setOriginalprice(java.math.BigDecimal originalprice) {
        this.originalprice = originalprice;
    }
    /**
     * 折扣
     */
    public java.math.BigDecimal getDiscount() {
        return discount;
    }

    /**
     * 折扣
     */
    public void setDiscount(java.math.BigDecimal discount) {
        this.discount = discount;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNums() {
        return nums;
    }

    /**
     * 数量
     */
    public void setNums(java.math.BigDecimal nums) {
        this.nums = nums;
    }
    /**
     * 已成交数量
     */
    public java.math.BigDecimal getSellNums() {
        return sellNums;
    }

    /**
     * 已成交数量
     */
    public void setSellNums(java.math.BigDecimal sellNums) {
        this.sellNums = sellNums;
    }
    /**
     * 预定中数量
     */
    public java.math.BigDecimal getPreNums() {
        return preNums;
    }

    /**
     * 预定中数量
     */
    public void setPreNums(java.math.BigDecimal preNums) {
        this.preNums = preNums;
    }
    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public java.math.BigDecimal getRotatableNums() {
        return rotatableNums;
    }

    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public void setRotatableNums(java.math.BigDecimal rotatableNums) {
        this.rotatableNums = rotatableNums;
    }
    /**
     * 剩余数量(上架-已成交)
     */
    public java.math.BigDecimal getRemainingNums() {
        return remainingNums;
    }

    /**
     * 剩余数量(上架-已成交)
     */
    public void setRemainingNums(java.math.BigDecimal remainingNums) {
        this.remainingNums = remainingNums;
    }
    /**
     * 0-是  1-否
     */
    public String getIsPack() {
        return isPack;
    }

    /**
     * 0-是  1-否
     */
    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }
    /**
     * 地址主键
     */
    public Long getAddressId() {
        return addressId;
    }

    /**
     * 地址主键
     */
    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }
    /**
     * 出售方
     */
    public String getAddressName() {
        return addressName;
    }

    /**
     * 出售方
     */
    public void setAddressName(String addressName) {
        this.addressName = addressName;
    }
    /**
     * 
     */
    public String getProjectAddress() {
        return projectAddress;
    }

    /**
     * 
     */
    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    /**
     * 详细地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 所在地一级区域
     */
    public String getFirstLocation() {
        return firstLocation;
    }

    /**
     * 所在地一级区域
     */
    public void setFirstLocation(String firstLocation) {
        this.firstLocation = firstLocation;
    }
    /**
     * 所在地二级区域
     */
    public String getSecondLocation() {
        return secondLocation;
    }

    /**
     * 所在地二级区域
     */
    public void setSecondLocation(String secondLocation) {
        this.secondLocation = secondLocation;
    }
    /**
     * 所在地三级区域
     */
    public String getThirdLocation() {
        return thirdLocation;
    }

    /**
     * 所在地三级区域
     */
    public void setThirdLocation(String thirdLocation) {
        this.thirdLocation = thirdLocation;
    }
    /**
     * 所在地四级区域
     */
    public String getFourthLocation() {
        return fourthLocation;
    }

    /**
     * 所在地四级区域
     */
    public void setFourthLocation(String fourthLocation) {
        this.fourthLocation = fourthLocation;
    }
    /**
     * 所在地末级区域
     */
    public String getLocation() {
        return location;
    }

    /**
     * 所在地末级区域
     */
    public void setLocation(String location) {
        this.location = location;
    }
    /**
     * 经度
     */
    public Double getLon() {
        return lon;
    }

    /**
     * 经度
     */
    public void setLon(Double lon) {
        this.lon = lon;
    }
    /**
     * 纬度
     */
    public Double getLat() {
        return lat;
    }

    /**
     * 纬度
     */
    public void setLat(Double lat) {
        this.lat = lat;
    }
    /**
     * 联系方式
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 联系方式
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 联系人
     */
    public String getName() {
        return name;
    }

    /**
     * 联系人
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 上架时间
     */
    public java.util.Date getShelfTime() {
        return shelfTime;
    }

    /**
     * 上架时间
     */
    public void setShelfTime(java.util.Date shelfTime) {
        this.shelfTime = shelfTime;
    }
    /**
     * 下架时间
     */
    public java.util.Date getLowerTime() {
        return lowerTime;
    }

    /**
     * 下架时间
     */
    public void setLowerTime(java.util.Date lowerTime) {
        this.lowerTime = lowerTime;
    }
    /**
     * 下架类型0-手动下架，1-售罄下架，2-回收下架
     */
    public Integer getLowerType() {
        return lowerType;
    }

    /**
     * 下架类型0-手动下架，1-售罄下架，2-回收下架
     */
    public void setLowerType(Integer lowerType) {
        this.lowerType = lowerType;
    }
    /**
     * 下架人
     */
    public Long getLower() {
        return lower;
    }

    /**
     * 下架人
     */
    public void setLower(Long lower) {
        this.lower = lower;
    }
    /**
     * 资产详情
     */
    public String getDetails() {
        return details;
    }

    /**
     * 资产详情
     */
    public void setDetails(String details) {
        this.details = details;
    }
    /**
     * 资产状态0-在售，1-下架，2-暂存，3-待回收，4-已回收
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 资产状态0-在售，1-下架，2-暂存，3-待回收，4-已回收
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 标签名称
     */
    public String getLabelName() {
        return labelName;
    }

    /**
     * 标签名称
     */
    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
    /**
     * 0-手动上架，1-加工上架
     */
    public Integer getType() {
        return type;
    }

    /**
     * 0-手动上架，1-加工上架
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 机具周转的订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 机具周转的订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 上架总金额
     */
    public java.math.BigDecimal getShelfMny() {
        return shelfMny;
    }

    /**
     * 上架总金额
     */
    public void setShelfMny(java.math.BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }
    
}
