/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.MaterialDealVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialDeal"})
public class MaterialDealController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialDealService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    public static final String EJC_MATERIAL_DEAL_XM = "EJC_MATERIAL_DEAL_XM";
    public static final String EJC_MATERIAL_DEAL_GS = "EJC_MATERIAL_DEAL_GS";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService goodsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialDealVO> saveOrUpdate(@RequestBody MaterialDealVO saveorUpdateVO) {
        List materialDealDetail;
        if (null == saveorUpdateVO.getId()) {
            String billCodeRule = saveorUpdateVO.getBelongType() == 0 ? EJC_MATERIAL_DEAL_XM : EJC_MATERIAL_DEAL_GS;
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveorUpdateVO.setBillCode((String)codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setFinishState(Integer.valueOf(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialDealDetail = saveorUpdateVO.getMaterialDealDetail()))) {
            QueryParam param = new QueryParam();
            param.getParams().put("belongType", new Parameter("eq", (Object)saveorUpdateVO.getBelongType()));
            param.getParams().put("orgId", new Parameter("eq", (Object)saveorUpdateVO.getOrgId()));
            List assetIds = materialDealDetail.stream().map(MaterialDealDetailVO::getAssetId).collect(Collectors.toList());
            param.getParams().put("assetId", new Parameter("in", assetIds));
            param.getParams().put("status", new Parameter("in", Arrays.asList(0, 3)));
            List goodsEntities = this.goodsService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)goodsEntities)) {
                Map<Long, List<GoodsEntity>> assetMap = goodsEntities.stream().collect(Collectors.groupingBy(GoodsEntity::getAssetId));
                for (MaterialDealDetailVO m : materialDealDetail) {
                    BigDecimal onNum;
                    Long assetId = m.getAssetId();
                    List<GoodsEntity> onGoodsEntities = assetMap.get(assetId);
                    Integer assetType = m.getAssetType();
                    if (1 == assetType && CollectionUtils.isNotEmpty(onGoodsEntities)) {
                        return CommonResponse.error((String)("\u8d44\u4ea7\u7f16\u53f7\u3010" + m.getAssetCode() + "\u3011\u7684\u53f0\u8f66\u5df2\u88ab\u4e0a\u67b6\u9501\u5b9a\u4e2d,\u6682\u4e0d\u80fd\u5904\u7f6e\uff01"));
                    }
                    BigDecimal dealNum = m.getDealNum();
                    if (dealNum.compareTo(onNum = m.getOnNum()) > 0) {
                        return CommonResponse.error((String)("\u8d44\u4ea7\u7f16\u53f7\u3010" + m.getAssetCode() + "\u3011\u7684\u5904\u7f6e\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5728\u573a\u6570\u91cf\uff01"));
                    }
                    if (!CollectionUtils.isNotEmpty(onGoodsEntities)) continue;
                    BigDecimal nums = BigDecimal.ZERO;
                    for (GoodsEntity g : onGoodsEntities) {
                        nums = nums.add(g.getRotatableNums() != null ? g.getRotatableNums() : BigDecimal.ZERO);
                    }
                    BigDecimal canDealNum = onNum.subtract(nums);
                    if (dealNum.compareTo(canDealNum) <= 0) continue;
                    return CommonResponse.error((String)("\u8d44\u4ea7\u7f16\u53f7\u3010" + m.getAssetCode() + "\u3011\u7684\u5904\u7f6e\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u5904\u7f6e\u6570\u91cf, \u5f53\u524d\u8d44\u4ea7\u5728\u573a\u6570\u91cf:" + onNum.setScale(2) + ", \u4e0a\u67b6\u9501\u5b9a\u6570\u91cf:" + nums.setScale(2) + ", \u53ef\u5904\u7f6e\u6570\u91cf:" + (BigDecimal.ZERO.compareTo(canDealNum) > 0 ? Double.valueOf(0.0) : canDealNum.setScale(2)) + "\uff01"));
                }
            }
        }
        MaterialDealEntity entity = (MaterialDealEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MaterialDealEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        MaterialDealVO vo = (MaterialDealVO)BeanMapper.map((Object)((Object)entity), MaterialDealVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialDealVO> queryDetail(Long id) {
        MaterialDealEntity entity = (MaterialDealEntity)((Object)this.service.selectById(id));
        MaterialDealVO vo = (MaterialDealVO)BeanMapper.map((Object)((Object)entity), MaterialDealVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDealVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        param.getParams().put("belongType", new Parameter("eq", (Object)0));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialDealVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList4Org"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList4Org(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        param.getParams().put("belongType", new Parameter("eq", (Object)1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialDealVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

