/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.MaterialDealDetailEntity;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.IMaterialDealDetailService;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private static final String PANHUO_ZC = "ASSET_ZC";
    private static final String ASSET_CODE = "ASSET_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ITurnoverRecordService turnoverRecordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IMaterialDealService dealService;
    @Autowired
    private IMaterialDealDetailService dealDetailService;

    @Override
    public CommonResponse<GoodsVO> saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal siteNums = vo.getSiteNums() == null ? BigDecimal.ZERO : vo.getSiteNums();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getAssetId, (Object)vo.getAssetId());
        lambdachange.eq(GoodsEntity::getOrgId, (Object)vo.getOrgId());
        lambdachange.in(GoodsEntity::getStatus, new Object[]{0, 3});
        List goodsEntities = super.list((Wrapper)lambdachange);
        BigDecimal remianNums = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)goodsEntities)) {
            remianNums = goodsEntities.stream().map(e -> e.getRemainingNums() == null ? BigDecimal.ZERO : e.getRemainingNums()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        LambdaQueryWrapper dealLanm = Wrappers.lambdaQuery();
        dealLanm.eq(BaseEntity::getTenantId, (Object)tenantId);
        dealLanm.eq(MaterialDealEntity::getOrgId, (Object)vo.getOrgId());
        dealLanm.eq(MaterialDealEntity::getBelongType, (Object)vo.getBelongType());
        dealLanm.in(MaterialDealEntity::getBillState, new Object[]{0});
        List list = this.dealService.list((Wrapper)dealLanm);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper dealDetailLanm = Wrappers.lambdaQuery();
            dealDetailLanm.eq(MaterialDealDetailEntity::getAssetId, (Object)vo.getAssetId());
            dealDetailLanm.in(MaterialDealDetailEntity::getPId, ids);
            List detailList = this.dealDetailService.list((Wrapper)dealDetailLanm);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                BigDecimal dealNum = detailList.stream().map(e -> e.getDealNum() == null ? BigDecimal.ZERO : e.getDealNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                siteNums = siteNums.subtract(dealNum);
            }
        }
        if (1 == entity.getType() && 1 == entity.getAssetType()) {
            CommonResponse assetCode = this.billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId);
            if (!assetCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setAssetCode((String)assetCode.getData());
            entity.setAssetId(IdWorker.getId());
        }
        if (0 == entity.getType() && 0 == entity.getBelongType() && 1 == entity.getAssetBelongType()) {
            entity.setStatus(3);
            entity.setRecoveryType(2);
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        BigDecimal maxNextAdd = siteNums.subtract(remianNums);
        if (entity.getNums().compareTo(maxNextAdd) > 0) {
            return CommonResponse.error((String)"\u8be5\u8d44\u4ea7\u7f16\u7801\u5bf9\u5e94\u7684\u6750\u6599\u4e0a\u67b6\u6570\u91cf\u5df2\u8d85\u8fc7\u5728\u573a\u6570\u91cf\uff0c\u4e0d\u53ef\u4e0a\u67b6(\u8bf7\u68c0\u67e5\u5728\u552e\u548c\u672a\u751f\u6548\u62a5\u5e9f\u5355)");
        }
        super.saveOrUpdate((Object)entity, false);
        if (1 == entity.getType() && 1 == entity.getAssetType()) {
            TurnoverRecordEntity turnoverRecordEntity = (TurnoverRecordEntity)((Object)this.turnoverRecordService.getById(vo.getTurnoverRecordId()));
            turnoverRecordEntity.setId(null);
            turnoverRecordEntity.setSourceId(entity.getId());
            turnoverRecordEntity.setSourceDetailId(entity.getId());
            turnoverRecordEntity.setOrgId(entity.getOrgId());
            turnoverRecordEntity.setOrgName(entity.getOrgName());
            turnoverRecordEntity.setProjectName(null);
            turnoverRecordEntity.setProjectId(null);
            turnoverRecordEntity.setCreateTime(entity.getCreateTime());
            turnoverRecordEntity.setCreateUserCode(entity.getCreateUserCode());
            turnoverRecordEntity.setSourceType(TurnoverTypeEnum.\u8d44\u4ea7\u5229\u65e7.getCode());
            turnoverRecordEntity.setSourceTypeName(TurnoverTypeEnum.\u8d44\u4ea7\u5229\u65e7.getName());
            turnoverRecordEntity.setSourceDate(entity.getCreateTime());
            turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(turnoverRecordEntity.getNum() == null ? BigDecimal.ZERO : turnoverRecordEntity.getNum()));
            this.turnoverRecordService.save((Object)turnoverRecordEntity);
            TurnoverRecordEntity saveEntity = (TurnoverRecordEntity)((Object)BeanMapper.map((Object)((Object)entity), TurnoverRecordEntity.class));
            saveEntity.setAssetCode(entity.getAssetCode());
            saveEntity.setAssetId(entity.getAssetId());
            saveEntity.setSourceId(entity.getId());
            saveEntity.setSourceDetailId(entity.getId());
            saveEntity.setSourceType(TurnoverTypeEnum.\u52a0\u5de5\u4e0a\u67b6.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.\u52a0\u5de5\u4e0a\u67b6.getName());
            saveEntity.setSourceDate(entity.getCreateTime());
            saveEntity.setTon(entity.getCapacity());
            saveEntity.setSourceId(entity.getId());
            saveEntity.setSourceDetailId(entity.getId());
            saveEntity.setNum(entity.getNums());
            saveEntity.setUseAssetId(vo.getUseAssetId());
            saveEntity.setUseAssetCode(vo.getUseAssetCode());
            saveEntity.setUseTon(vo.getUseTon());
            saveEntity.setAddTon(vo.getAddTon());
            this.turnoverRecordService.save((Object)saveEntity);
        }
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)resvo);
    }

    @Override
    public CommonResponse<GoodsVO> saveGoodsTemp(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (vo.getId() != null && vo.getId() > 0L) {
            List<LabeldetailEntity> listlb = entity.getLabels();
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        if (1 == entity.getType() && 1 == entity.getAssetType()) {
            CommonResponse assetCode = this.billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId);
            if (!assetCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setAssetCode((String)assetCode.getData());
            entity.setAssetId(IdWorker.getId());
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)resvo);
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsDetailsVO vo = (GoodsDetailsVO)BeanMapper.map((Object)((Object)entity), GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange.gt(GoodsEntity::getRotatableNums, (Object)0);
        int nums = super.count((Wrapper)lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(GoodsEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.gt(GoodsEntity::getRotatableNums, (Object)0);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
        }
        if (0 == entity.getAssetType() || 1 == entity.getAssetType()) {
            // empty if block
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listc = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listc)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)listc.get(0))).getId());
        } else {
            vo.setIsCollect(Integer.valueOf(0));
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((GoodsMapper)this.baseMapper).getGoods(pages, queryWrapper, lon, lat);
    }

    @Override
    public ReportVO orgStatistics(Long orgId) {
        ReportVO goodsNumsIngVo;
        CommonResponse orgListResp;
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        if (null == orgId || orgId <= 0L) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ReportVO resVO = new ReportVO();
        ReportVO pronumsVo = ((GoodsMapper)this.baseMapper).getPronums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != pronumsVo) {
            resVO.setProNums(pronumsVo.getProNums() == null ? BigDecimal.ZERO : pronumsVo.getProNums());
        } else {
            resVO.setProNums(BigDecimal.ZERO);
        }
        ReportVO goodsNumsVo = ((GoodsMapper)this.baseMapper).getGoodsnums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != goodsNumsVo) {
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsAmount());
            if (null != goodsNumsVo.getShelfTime()) {
                int days = (int)((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / 86400000L);
                resVO.setDays(days);
            }
        } else {
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }
        if (null != (goodsNumsIngVo = ((GoodsMapper)this.baseMapper).getGoodsnumsIng(InvocationInfoProxy.getTenantid(), commonOrgIds))) {
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfAmount());
        } else {
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }
        ReportVO OrdernumsVo = ((GoodsMapper)this.baseMapper).getOrdernums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != OrdernumsVo) {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        } else {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        }
        return resVO;
    }

    @Override
    public List<ReportVO> periodStatistics(List<Long> commonOrgIds) {
        return ((GoodsMapper)this.baseMapper).getPeriodStatistics(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }

    @Override
    public List<ReportVO> proportion(List<Long> commonOrgIds, int type) {
        if (type == 0) {
            return ((GoodsMapper)this.baseMapper).getGoodsProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        if (1 == type) {
            return ((GoodsMapper)this.baseMapper).getGoodsIngProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        return ((GoodsMapper)this.baseMapper).getProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }
}

