/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.bean.PlanEntity;
import com.ejianc.business.asset.mapper.CheckMapper;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String CRG_PRO_CHECK = "CRG_PRO_CHECK";
    private static final String CRG_ORG_CHECK = "CRG_ORG_CHECK";
    private static final String ASSET_CODE = "ASSET_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAllotService service;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Override
    public CommonResponse<CheckVO> saveOrUpdate(CheckVO checkVO) {
        Long planId;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)checkVO.getBillCode())) {
            CommonResponse billCode = null;
            if (checkVO.getBelongType() == 0) {
                billCode = this.billCodeApi.getCodeBatchByRuleCode(CRG_PRO_CHECK, tenantId);
            }
            if (checkVO.getBelongType() == 1) {
                billCode = this.billCodeApi.getCodeBatchByRuleCode(CRG_ORG_CHECK, tenantId);
            }
            if (billCode.isSuccess()) {
                checkVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)checkVO, CheckEntity.class));
        List<CheckDetailEntity> checkDetail = entity.getCheckDetail();
        String materialName = "";
        int count = 0;
        ArrayList<String> materialNameList = new ArrayList<String>();
        if (checkDetail != null && checkDetail.size() > 0) {
            for (CheckDetailEntity checkDetailEntity : checkDetail) {
                if (null == checkDetailEntity.getAssetCode()) {
                    ++count;
                }
                if (materialNameList.contains(checkDetailEntity.getMaterialName())) continue;
                materialNameList.add(checkDetailEntity.getMaterialName());
            }
        }
        if (count > 0) {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId, count);
            List assetCodeList = (List)codeBatchByRuleCode.getData();
            block1: for (String code : assetCodeList) {
                for (CheckDetailEntity checkDetailEntity : checkDetail) {
                    if (null != checkDetailEntity.getAssetCode()) continue;
                    checkDetailEntity.setAssetCode(code);
                    checkDetailEntity.setAssetId(IdWorker.getId());
                    continue block1;
                }
            }
        }
        if (materialNameList != null && materialNameList.size() > 0) {
            for (String materialNames : materialNameList) {
                materialName = materialName + materialNames + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        if (null != entity.getAllotId() && 0L != entity.getAllotId()) {
            AllotEntity allotEntity = (AllotEntity)((Object)this.service.selectById(entity.getAllotId()));
            allotEntity.setState(1);
            this.service.updateById((Object)allotEntity);
        }
        if ((planId = entity.getPlanId()) != null) {
            PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(planId));
            List<CheckDetailEntity> detail = entity.getCheckDetail();
            List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
            if (CollectionUtils.isNotEmpty(detail) && CollectionUtils.isNotEmpty(planDetail)) {
                Map<Long, CheckDetailEntity> numMap = detail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));
                boolean isNew = false;
                CheckEntity oldCheck = null;
                if (entity.getId() != null) {
                    oldCheck = (CheckEntity)((Object)this.checkService.selectById(entity.getId()));
                    boolean bl = isNew = oldCheck == null;
                }
                if (entity.getId() == null && isNew) {
                    for (PlanDetailEntity p : planDetail) {
                        Long materialId = p.getMaterialId();
                        CheckDetailEntity dec = numMap.get(materialId);
                        if (dec == null || "del".equals(dec.getRowState())) continue;
                        BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                        p.setSumNums(_sum.add(dec.getCheckNum()));
                    }
                } else if (oldCheck != null) {
                    List<CheckDetailEntity> oldDetail = oldCheck.getCheckDetail();
                    Map<Object, Object> oldMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(oldDetail)) {
                        oldMap = oldDetail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));
                    }
                    for (PlanDetailEntity p : planDetail) {
                        CheckDetailEntity old;
                        Long materialId = p.getMaterialId();
                        CheckDetailEntity dec = numMap.get(materialId);
                        if (dec == null) continue;
                        if (dec.getId() == null) {
                            if (!"add".equals(dec.getRowState())) continue;
                            BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                            p.setSumNums(_sum.add(dec.getCheckNum()));
                            continue;
                        }
                        if ("del".equals(dec.getRowState())) {
                            old = (CheckDetailEntity)((Object)oldMap.get(materialId));
                            BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                            p.setSumNums(_sum.subtract(old.getCheckNum()));
                            continue;
                        }
                        old = (CheckDetailEntity)((Object)oldMap.get(materialId));
                        BigDecimal subtract = dec.getCheckNum().subtract(old.getCheckNum());
                        BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                        p.setSumNums(_sum.add(subtract));
                    }
                }
            }
            BigDecimal _sumNums = BigDecimal.ZERO;
            BigDecimal _nums = BigDecimal.ZERO;
            for (PlanDetailEntity p : planDetail) {
                if (p.getSumNums() != null && p.getSumNums().compareTo(p.getNums()) > 0) {
                    return CommonResponse.success((String)("\u7269\u8d44\u3010" + p.getMaterialName() + "\u3011\u7d2f\u8ba1\u9a8c\u6536\u6570\u91cf\u5df2\u8d85\u8ba1\u5212\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01"));
                }
                _sumNums = MathUtil.safeAdd(_sumNums, p.getSumNums());
                _nums = MathUtil.safeAdd(_nums, p.getNums());
            }
            planEntity.setCheckState(_sumNums.compareTo(_nums) == 0 ? 1 : 0);
            this.planService.saveOrUpdate((Object)planEntity, false);
        }
        this.checkService.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<CheckVO> copyCheckFile(Long goodsId) {
        Long id = IdWorker.getId();
        CommonResponse response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(goodsId.toString(), "BT210510000000005", "drawingUpload", id.toString(), "BT210508000000002", "drawingUpload");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        CheckVO checkVO = new CheckVO();
        checkVO.setId(id);
        CommonResponse listCommonResponse = this.iAttachmentApi.queryListBySourceId(id, "BT210508000000002", "drawingUpload", null);
        if (listCommonResponse.isSuccess()) {
            checkVO.setFileList((List)listCommonResponse.getData());
        }
        return CommonResponse.success((String)"\u9644\u4ef6\u590d\u5236\u6210\u529f\uff01", (Object)checkVO);
    }

    @Override
    public CommonResponse<CheckVO> copyPlanFile(Long planId, CheckVO checkVO) {
        Long id = IdWorker.getId();
        CommonResponse response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(planId.toString(), "BT210508000000001", "drawingUpload", id.toString(), "BT210508000000002", "drawingUpload");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        checkVO.setId(id);
        CommonResponse listCommonResponse = this.iAttachmentApi.queryListBySourceId(id, "BT210508000000002", "drawingUpload", null);
        if (listCommonResponse.isSuccess()) {
            checkVO.setFileList((List)listCommonResponse.getData());
        }
        return CommonResponse.success((String)"\u9644\u4ef6\u590d\u5236\u6210\u529f\uff01", (Object)checkVO);
    }
}

