package com.ejianc.business.asset.mapper;

import com.ejianc.business.asset.vo.CheckDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.asset.bean.CheckEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface CheckMapper extends BaseCrudMapper<CheckEntity> {
    @Select("SELECT material_name,check_num,allot_num,check_tax_money,allot_money FROM  ejc_panhuo_check_detail WHERE check_id=#{checkId} and material_name = #{materialName} AND dr = 0  GROUP BY material_name ")
    List<CheckDetailVO> selectByMaterialName(@Param("checkId") Long checkId, @Param("materialName") String materialName);
    @Select("<script>"+
            "SELECT id FROM  ejc_panhuo_check WHERE dr =0" +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>"+
            "</script>")
    List<Long> selectCheckId(@Param("projectId") Long projectId, @Param("orgId") Long orgId);
    @Select("<script>"+
            "SELECT allot_id FROM  ejc_panhuo_check WHERE dr =0" +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>"+
            "AND allot_id IS NOT NULL"+
            "</script>")
    List<Long> selectAllotId(Long projectId,Long orgId);

}
