package com.ejianc.business.asset.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 周转记录
 *
 * @author generator
 */
@Mapper
public interface TurnoverRecordMapper extends BaseCrudMapper<TurnoverRecordEntity> {

    List<TurnoverRecordVO> queryMaterialRef(Page<TurnoverRecordVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<TurnoverRecordVO> queryMaterialRef(@Param(Constants.WRAPPER) QueryWrapper wrapper);
    @Select("<script> " +
            "SELECT *,SUM(num) AS sumNum FROM ejc_panhuo_turnover_record WHERE dr = 0 " +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "GROUP BY material_name " +
            "</script>")
    List<TurnoverRecordVO> selectByProjectId(@Param("projectId") Long projectId, @Param("orgId") Long orgId);

    @Select("<script>"+
            "SELECT * FROM ejc_panhuo_turnover_record WHERE dr = 0 " +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "and material_name =#{materialName}"+
            "</script>")
    List<TurnoverRecordVO> selectDetail(Long projectId, Long orgId, String materialName);
    @Select("select  *,SUM(num) AS sumNum from ejc_panhuo_turnover_record WHERE dr = 0 and material_name =#{materialName} and project_id is not null GROUP BY project_id")
    List<TurnoverRecordVO> selectProjectDetail(String materialName);
    @Select("<script>"+
            "SELECT sum(num) as num,sum(total_money) as totalMoney,source_type_name FROM ejc_panhuo_turnover_record WHERE dr = 0 " +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "and material_name =#{materialName}"+
            "GROUP BY source_type_name " +
            "</script>")
    List<TurnoverRecordVO> selectByName(Long projectId, Long orgId, String materialName);
    @Select("select * from ejc_panhuo_turnover_record WHERE dr = 0 and material_name =#{materialName}")
    List<TurnoverRecordVO> selectDetailByMaterialName(String materialName);
}
