/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.vo.AssignVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"recovery"})
public class RecoveryController
implements Serializable {
    @Autowired
    private IGoodsService service;
    @Autowired
    private ITurnoverRecordService turnoverRecordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        fuzzyFields.add("belongOrgName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/assign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody AssignVO assignVO) {
        List goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty((Collection)goods)) {
            Integer flag = assignVO.getFlag();
            List goodsIds = goods.stream().map(BaseVO::getId).collect(Collectors.toList());
            List goodsEntities = (List)this.service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty((Collection)goodsEntities)) {
                if (1 == flag) {
                    for (GoodsEntity e : goodsEntities) {
                        e.setRecoveryType(1);
                        e.setAssetBelongType(1);
                        e.setBelongOrgId(assignVO.getOrgId());
                        e.setBelongOrgName(assignVO.getOrgName());
                    }
                } else {
                    for (GoodsEntity e : goodsEntities) {
                        e.setRecoveryType(0);
                        e.setAssetBelongType(0);
                        e.setBelongOrgId(null);
                        e.setBelongOrgName(null);
                    }
                }
                this.service.updateBatchById(goodsEntities);
                for (GoodsEntity entry : goodsEntities) {
                    this.logger.info("\u56de\u6536\u63d0\u9192\u6d88\u606f\u53d1\u9001>----------");
                    ArrayList<String> messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    ArrayList<String> sender = new ArrayList<String>();
                    sender.add(entry.getSeller() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    String subject = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + entry.getMaterialName() + "\u3011\u957f\u65f6\u95f4\u672a\u88ab\u5468\u8f6c\uff0c\u5df2\u88ab\u3010" + entry.getBelongOrgName() + "\u3011\u56de\u6536\u3002";
                    String content = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + entry.getMaterialName() + "\u3011\u957f\u65f6\u95f4\u672a\u88ab\u5468\u8f6c\uff0c\u5df2\u88ab\u3010" + entry.getBelongOrgName() + "\u3011\u56de\u6536\u3002";
                    this.sendMsg(messageType, sender, "notice", subject, content);
                }
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/recovery"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> recovery(@RequestBody AssignVO assignVO) {
        List goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty((Collection)goods)) {
            Integer flag = assignVO.getFlag();
            List goodsIds = goods.stream().map(BaseVO::getId).collect(Collectors.toList());
            List goodsEntities = (List)this.service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty((Collection)goodsEntities)) {
                for (GoodsEntity e : goodsEntities) {
                    e.setStatus(4);
                    e.setLower(InvocationInfoProxy.getUserid());
                    e.setLowerType(2);
                    e.setLowerTime(new Date());
                }
                ArrayList<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<TurnoverRecordEntity>();
                for (GoodsEntity e : goodsEntities) {
                    turnoverRecordEntitList.add(this.getGSRecord(TurnoverTypeEnum.\u8d44\u4ea7\u56de\u6536, e));
                    turnoverRecordEntitList.add(this.getXMRecord(TurnoverTypeEnum.\u56de\u6536\u9000\u573a, e));
                }
                this.turnoverRecordService.saveBatch(turnoverRecordEntitList);
                this.service.updateBatchById(goodsEntities);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private TurnoverRecordEntity getXMRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getOrgId());
        turnoverRecordEntity.setOrgName(e.getOrgName());
        turnoverRecordEntity.setProjectId(e.getProjectId());
        turnoverRecordEntity.setProjectName(e.getProjectName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(e.getBelongType());
        turnoverRecordEntity.setTon(e.getCapacity());
        turnoverRecordEntity.setAssetBelongType(0);
        turnoverRecordEntity.setPrice(e.getPrice());
        turnoverRecordEntity.setTotalMoney(e.getShelfMny());
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(num));
        return turnoverRecordEntity;
    }

    private TurnoverRecordEntity getGSRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setOrgName(e.getBelongOrgName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(1);
        turnoverRecordEntity.setAssetBelongType(1);
        turnoverRecordEntity.setBelongOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setTon(e.getCapacity());
        turnoverRecordEntity.setBelongOrgName(e.getBelongOrgName());
        turnoverRecordEntity.setPrice(e.getPrice());
        turnoverRecordEntity.setTotalMoney(e.getShelfMny());
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(num);
        return turnoverRecordEntity;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

