package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.service.IPlanDetailService;
import com.ejianc.business.asset.vo.PlanDetailVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.PlanEntity;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.vo.PlanVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 计划实体
 *
 * @author generator
 */
@Controller
@RequestMapping("plan")
public class PlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanService service;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = service.selectById(id);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param
     * @Description queryDetail 根据项目主键和当前登录人获取当前登录人最近一次创建的计划信息
     */
    @RequestMapping(value = "/queryLatelyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryLinkDetail(Long projectId) {
        List<PlanEntity> details = null;
        LambdaQueryWrapper<PlanEntity> lambda = Wrappers.<PlanEntity>lambdaQuery();
        lambda.eq(PlanEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(PlanEntity::getCreateUserCode, InvocationInfoProxy.getUsercode());
        lambda.eq(PlanEntity::getProjectId, projectId);
        lambda.orderByDesc(PlanEntity::getCreateTime);
        details = service.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0), PlanVO.class));
        } else {
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        service.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<PlanEntity> page = service.queryPage(param, false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<PlanEntity> pageData = service.queryPage(param, false);
        List<PlanVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), PlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getPlanType() == 0) {
                    vo.setPlanTypeName("项目自采");
                }
                if(vo.getPlanType() == 1){
                    vo.setPlanTypeName("内部调拨");
                }
                if(vo.getPlanType() == 2){
                    vo.setPlanTypeName("租赁计划");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("planExport.xlsx", beans, response);
    }

    /**
     * 自采计划参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/planRef")
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> planRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                 @RequestParam(defaultValue = "10") Integer pageSize,
                                                 @RequestParam(value = "condition", required = false) String condition,
                                                 @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("planName");
        fuzzyFields.add("planDate");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("planType", new Parameter("eq", 0));
        List<Integer> billState = new ArrayList<>();
        billState.add(1);
        billState.add(3);
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billState));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        queryParam.getParams().put("checkState", new Parameter(QueryParam.NE, 1));
        IPage<PlanEntity> pageData = service.queryPage(queryParam, false);
        IPage<PlanVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), PlanVO.class));
        for (PlanVO record : result.getRecords()) {
            if(record.getPlanType() == 0){
                record.setPlanTypeName("项目自采");
            }
            if(record.getPlanType() == 1){
                record.setPlanTypeName("内部调拨");
            }
            if(record.getPlanType() == 2){
                record.setPlanTypeName("租赁计划");
            }
        }
        return CommonResponse.success("调拨单列表查询成功！", result);
    }

    /**
     * 计划参照数
     */
    @RequestMapping(value = "/referApplyTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referApplyTree(@RequestParam Integer pageNumber,@RequestParam Integer pageSize,
                                               @RequestParam String condition
    ) {
        if(StringUtils.isEmpty(condition) || !condition.contains("projectId")){
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if(null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PlanEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for(PlanEntity entity:dataList) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getPlanName());
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
    /**
     * @Date 计划申请子表参照数据
     */
    @RequestMapping(value = "/refDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanDetailVO>> refdata(@RequestParam Integer pageNumber,
                                                       @RequestParam Integer pageSize,
                                                       String relyCondition,
                                                       String relyNode ,
                                                       String searchText,
                                                       @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        Map<String, Parameter>  param = queryParam.getParams();
        if(!StringUtils.isEmpty(relyCondition)){
            param.put("plan_id",new Parameter(QueryParam.EQ,relyCondition.split("=")[1]));
        }else {
            throw new BusinessException("请选择申请单！");
        }

        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            for(String key : search.keySet()){
                queryParam.getParams().put(key,new Parameter(QueryParam.LIKE,search.get(key).toString()));
            }
        }
        IPage<PlanDetailEntity> pageData = planDetailService.queryPage(queryParam, false);
        IPage<PlanDetailVO> voPage = null;
        if(pageData!=null){
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(pageData.getRecords(),PlanDetailVO.class));
            for (PlanDetailVO record : voPage.getRecords()) {
                record.setAssetTypeName(record.getAssetType()==0?"周转材":"台车");
            }
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }

}
