package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.AssignVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 回收控制器
 * @date 2021-05-14
 */
@Controller
@RequestMapping("recovery")
public class RecoveryController implements Serializable {

    @Autowired
    private IGoodsService service;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;

    @Autowired
    private IAllotService allotService;

    @Autowired
    private SessionManager sessionManager;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        fuzzyFields.add("belongOrgName");
        fuzzyFields.add("billCode");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //启用状态
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param assignVO
     * @description: 指定/取消指定操作
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021-05-14
     */
    @RequestMapping(value = "/assign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody AssignVO assignVO) {
        List<GoodsVO> goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty(goods)) {
            Integer flag = assignVO.getFlag();
            List<Long> goodsIds = goods.stream().map(GoodsVO::getId).collect(Collectors.toList());
            List<GoodsEntity> goodsEntities = (List<GoodsEntity>) service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty(goodsEntities)) {
                //指定操作
                if (1 == flag) {
                    for (GoodsEntity e : goodsEntities) {
                        //已制定回收
                        e.setRecoveryType(1);
                        e.setAssetBelongType(1);
                        e.setBelongOrgId(assignVO.getOrgId());
                        e.setBelongOrgName(assignVO.getOrgName());
                    }
                } else {
                    for (GoodsEntity e : goodsEntities) {
                        //已制定回收
                        e.setRecoveryType(0);
                        e.setAssetBelongType(0);
                        e.setBelongOrgId(null);
                        e.setBelongOrgName(null);
                    }
                }
                service.updateBatchById(goodsEntities);
                for (GoodsEntity entry : goodsEntities) {
                    //回收提醒消息发送
                    logger.info("回收提醒消息发送>----------");
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    List<String> sender = new ArrayList<>();
                    sender.add(entry.getSeller() + "");
                    String mobileUrl = "";
                    logger.info("发送信息给发布人:>----------" + sender + baseHost);
                    String subject = "您上架的物资【" + entry.getMaterialName() + "】长时间未被周转，已被【" + assignVO.getOrgName() + "】回收。";
                    String content = "您上架的物资【" + entry.getMaterialName() + "】长时间未被周转，已被【" + assignVO.getOrgName()  + "】回收。";
                    this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

                }
            }

        }

        return CommonResponse.success("操作成功！");
    }


    /**
     * @param assignVO
     * @description: 回收
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021-05-14
     */
    @RequestMapping(value = "/recovery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> recovery(@RequestBody AssignVO assignVO) {
        List<GoodsVO> goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty(goods)) {
            Integer flag = assignVO.getFlag();
            List<Long> goodsIds = goods.stream().map(GoodsVO::getId).collect(Collectors.toList());
            List<GoodsEntity> goodsEntities = (List<GoodsEntity>) service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty(goodsEntities)) {
                //回收
                for (GoodsEntity e : goodsEntities) {
                    //已回收
                    e.setStatus(4);
                    e.setLower(InvocationInfoProxy.getUserid());
                    //回收下架
                    e.setLowerType(2);
                    e.setLowerTime(new Date());
                }
                List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
                for (GoodsEntity e : goodsEntities) {
                    //公司的资产回收
                    turnoverRecordEntitList.add(this.getGSRecord(TurnoverTypeEnum.资产回收, e));
                    //项目的回收退场
                    turnoverRecordEntitList.add(this.getXMRecord(TurnoverTypeEnum.回收退场, e));

                    //生成调拨单
                    AllotVO allotVO = BeanMapper.map(e, AllotVO.class);
                    allotVO.setGoodsId(e.getId());
                    allotVO.setId(null);
                    allotVO.setDealrTime(new Date());
                    allotVO.setBillCode(null);
                    allotVO.setOrderId(e.getId());
                    allotVO.setAmount(e.getShelfMny());
                    allotVO.setSellOrg(e.getOrgId());
                    allotVO.setSellOrgName(e.getOrgName());
                    allotVO.setSellProject(e.getProjectId());
                    allotVO.setSellProjectName(e.getProjectName());
                    allotVO.setBuyOrg(e.getBelongOrgId());
                    allotVO.setBuyOrgName(e.getBelongOrgName());
                    allotVO.setOrderUserId(sessionManager.getUserContext().getUserId());
                    allotVO.setOrderUserName(sessionManager.getUserContext().getUserName());
                    allotVO.setConfirmer(sessionManager.getUserContext().getUserId());
                    allotVO.setConfirmerName(sessionManager.getUserContext().getUserName());
                    allotVO.setBillState(1);
                    allotVO.setState(0);
                    allotService.saveAllotRecovery(allotVO);

                }
                turnoverRecordService.saveBatch(turnoverRecordEntitList);
                service.updateBatchById(goodsEntities);

            }

        }

        return CommonResponse.success("操作成功！");
    }


    /**
     * @description: 项目的回收退场
     *
     * @param t
     * @param e
     * @return: com.ejianc.business.asset.bean.TurnoverRecordEntity
     * @author songlx
     * @date: 2021-05-14
     */
    private TurnoverRecordEntity getXMRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getOrgId());
        turnoverRecordEntity.setOrgName(e.getOrgName());
        turnoverRecordEntity.setProjectId(e.getProjectId());
        turnoverRecordEntity.setProjectName(e.getProjectName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(e.getBelongType());
        turnoverRecordEntity.setTon(e.getCapacity());
        turnoverRecordEntity.setAssetBelongType(0);
        turnoverRecordEntity.setPrice(e.getPrice());
        turnoverRecordEntity.setTotalMoney(e.getShelfMny());
        //可周转数量
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(num));

        return turnoverRecordEntity;
    }

    /**
     * @description: 公司的资产回收
     *
     * @param t
     * @param e
     * @return: com.ejianc.business.asset.bean.TurnoverRecordEntity
     * @author songlx
     * @date: 2021-05-14
     */
    private TurnoverRecordEntity getGSRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setOrgName(e.getBelongOrgName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(1);
        turnoverRecordEntity.setAssetBelongType(1);
        turnoverRecordEntity.setBelongOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setTon(e.getCapacity());
        turnoverRecordEntity.setBelongOrgName(e.getBelongOrgName());
        turnoverRecordEntity.setPrice(e.getPrice());
        turnoverRecordEntity.setTotalMoney(e.getShelfMny());
        //可周转数量
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(num);

        return turnoverRecordEntity;
    }

    @RequestMapping(value = "/findOrgByType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OrgVO>> findOrgByType(@RequestParam("tenantId") Long tenantId, @RequestParam("typeList") List<Integer> typeList, @RequestParam(value = "searchText",required = false) String searchText){
         return orgApi.findOrgByType(tenantId,typeList,searchText);
    }

  public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
    logger.info("发送消息开始！===========");
    PushMsgParameter parameter = new PushMsgParameter();
    List<String> channel = new ArrayList<>();
    if (messageType.contains("sys")) {
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
    }
    if (messageType.contains("smsg")) {
        // 短信消息
        // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
    }
    if (messageType.contains("weChat")) {
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
    }
    String[] receivers = user.toArray(new String[user.size()]);
    parameter.setReceivers(receivers);// 收信人
    parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
    parameter.setMsgType(msgType);
    parameter.setSubject(subject);// 标题
    parameter.setContent(content);// 内容
    parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
    parameter.setSendUserId(InvocationInfoProxy.getUserid());

    if (messageType.contains("weChat")) {
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", cgddAgentid);
        weixineeParams.put("secret", cgddSecret);
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "消息提醒");
        weixineeParams.put("description", subject);
        weixineeParams.put("url", url);
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);
    }

    try {
        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.error("消息发送成功---------------->" + result.getMsg());
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
        }
    } catch (Exception e) {
        logger.error("调用消息中心RPC服务异常--------------" + e);
    }
 }
}
