package com.ejianc.business.asset.mapper;

import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.MaterialDealVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 报废处置主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface MaterialDealMapper extends BaseCrudMapper<MaterialDealEntity> {
    @Select("<script>"+
            "SELECT material_name,SUM(deal_num) AS deal_num,SUM(deal_money) AS deal_money FROM  ejc_panhuo_material_deal_detail WHERE dr =0" +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "and material_name =#{materialName}"+
            "GROUP BY material_name"+
            "</script>")
    List<MaterialDealDetailVO> selectDetail(Long projectId,Long orgId ,String materialName);

    @Select("SELECT * FROM ejc_panhuo_material_deal WHERE bill_state=3 AND finish_state=1 AND deal_date BETWEEN CURRENT_DATE() -7 AND CURRENT_DATE")
   List<MaterialDealVO>  afterMaterialDeal();
}