package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.util.IPUtils;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.support.idworker.util.IdWorker;
import com.maxmind.geoip2.DatabaseReader;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("goods")
public class GoodsController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IGoodsService service;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IUserApi userApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;

    static SimpleDateFormat sdf = new SimpleDateFormat(
            "yyyy-MM-dd");


    /**
     * @Description  上架
     */
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> publish(@RequestBody GoodsVO saveorUpdateVO) {
    	return service.saveGoods(saveorUpdateVO);
    }

    /**
     * @Description saveOrUpdate 上架暂存
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdateTemp(@RequestBody GoodsVO saveorUpdateVO) {
        saveorUpdateVO.setStatus(2);
        return service.saveGoods(saveorUpdateVO);
    }

    /**
     * @Description updateMainimgPath 修改主图
     */
    @RequestMapping(value = "/updateMainimgPath", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody GoodsVO saveorUpdateVO) {
        LambdaUpdateWrapper<GoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(GoodsEntity::getId,saveorUpdateVO.getId());
        updateWrapper.set(GoodsEntity::getMainimgPath,saveorUpdateVO.getMainimgPath());
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
    	GoodsEntity entity = service.selectById(id);
    	GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 复制上架
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = service.selectById(id);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
//        vo.setId(null);
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setToolId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setRotatableNums(entity.getNums());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRotatableNums(entity.getNums());

//        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
//            vo.getImgsPath().forEach(e -> {
//                e.setSourceId(null);
//                e.setRowState("add");
//            });
//        }
        vo.setId(IdWorker.getId());
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                id.toString(),
                "BT200813000000001",
                "imgUpload",
                vo.getId().toString(),
                "BT200813000000001",
                "imgUpload"
                );
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        if(CollectionUtils.isNotEmpty(vo.getLabels())){
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
        lambdachange.eq(OrderEntity::getGoodsId, vos.get(0).getId());
        List<OrderEntity> list = orderService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该商品存在订单,不允许删除");
        }
        service.removeByIds(vos.stream().map(GoodsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(HttpServletRequest request,@RequestBody QueryParam param) throws Exception {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        fuzzyFields.add("unit");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter dealrTime = param.getParams().get("shelfTime");
        if(dealrTime != null && dealrTime.getValue() != null){
            String value = String.valueOf(dealrTime.getValue());
            String[] split = value.split(",");
            if(null != split && split.length == 2){
                try {
                    Calendar c = Calendar.getInstance();
                    c.setTime(sdf.parse(split[1]));
                    // 设置当前日期
                    c.add(Calendar.DATE, 1); // 日期加1
                    Date date = c.getTime(); // 结果
                    String format = sdf.format(date);
                    String newValue = split[0] + "," + format;
                    dealrTime.setValue(newValue);
                } catch (ParseException e) {
                    e.printStackTrace();
                }

            }

        }
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(0);//在售
        listStatus.add(3);//待回收
        param.getParams().put("status", new Parameter(QueryParam.IN, listStatus));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        Parameter lon = param.getParams().get("lon");
        Parameter lat = param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        String lonValue = "";
        String LatValue = "";
        if(null!=lon&&null!=lat){
            lonValue = lon.getValue()+"";
            LatValue = lat.getValue()+"";
        }else{
            ClassPathResource resource = new ClassPathResource("GeoLite2-City_20210420/GeoLite2-City.mmdb");
            logger.info("-----"+resource);
            // 创建 GeoLite2 数据库
            // 读取数据库内容
            DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
            logger.info("******"+reader);
            // 访问IP
            String ip = IPUtils.getIP(request).split(",")[0];
            logger.info("******ip"+ip);
             if("127.0.0.1".equals(ip)){
                 ip = "115.60.183.195";
            }
            lonValue = IPUtils.getLongitude(reader, ip).toString();
            LatValue = IPUtils.getLatitude(reader, ip).toString();
        }

        Page<GoodsEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<GoodsEntity> list = service.queryGoods(page,wrapper,lonValue,LatValue);
        res.put("records", BeanMapper.mapList(list,GoodsVO.class));
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    /**
     * @Description queryGoodsDetail  资产集市-查询详情(带周转记录，其他项目等信息)
     * @param id
     */
    @RequestMapping(value = "/queryGoodsDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryGoodsDetail(id));
    }

    /**
     * @Description queryGoodsDetail  资产详情 - 卖家所有在售信息
     * @param
     */
    @RequestMapping(value = "/queryOtherGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(0);//在售
        param.getParams().put("status", new Parameter(QueryParam.IN, listStatus));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询数据成功！",pageData);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put(key, new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter(QueryParam.IN, childIds));
            }
        }
    }

    /**
     * @Description queryList 我的货架-出售中
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(0);//在售
        param.getParams().put("status", new Parameter(QueryParam.IN, listStatus));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-待回收
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsRecovery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsRecovery(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(3);//待回收
        param.getParams().put("status", new Parameter(QueryParam.IN, listStatus));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-已下架
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(1);//下架
        listStatus.add(4);//已回收
        param.getParams().put("status", new Parameter(QueryParam.IN, listStatus));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-暂存
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description updateStatus 下架
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = service.selectById(saveorUpdateVO.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
        List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
        if(null!=listOrder&&listOrder.size()>0){
            return  CommonResponse.error(5001,"存在未完成的订单,不允许下架！");
        }
        entity.setStatus(1);//下架
        entity.setLowerType(0);//下架类型0-手动下架，1-售罄下架，2-回收下架
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());

        //物资售空并下架 发送消息
        List<String> messageType= new ArrayList<>();
        messageType.add("sys");
        messageType.add("weChat");
        List<String> sender=new ArrayList<>();
        sender.add(entity.getSeller()+"");
        logger.info("发送信息给物资上架人:>----------"+sender);
        String formurl= baseHost+ "cr12g-panhuo-frontend/#/goodsManage/card?id="+entity.getId();
        String mobileUrl =baseHost+ "cr12g-panhuo-mobile/#/goodsManage/card?id="+entity.getId();
        String subject="您上架的物资【"+entity.getMaterialName()+"】已经售罄并下架";
        String content="您上架的物资【"+entity.getMaterialName()+"】已经售罄并下架,<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType,sender,"notice",subject,content,mobileUrl);


        service.saveOrUpdate(entity, false);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("操作成功！",vo);
    }

    /**
     * @Description shelfGoods 定时下架到期资产
     */
    @RequestMapping(value = "/shelfGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+day+"----");
        logger.debug("参数----"+day);
        if(day>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, 0);
            List<GoodsEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                List<GoodsEntity> listUp = new ArrayList<>();
                Map<Long,List<GoodsEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,entity.getId()));
                    queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
                    List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
                    if(null==listOrder||listOrder.size()<=0){  //不存在未完成订单，可下架
                        logger.debug("开始设置下架----");
                        entity.setStatus(1);//下架
                        entity.setLowerType(2);//下架类型0-手动下架，1-售罄下架，2-到期下架
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                        //为发消息做准备
                        if(map.containsKey(entity.getSeller())){
                            map.get(entity.getSeller()).add(entity);
                        }else{
                            List<GoodsEntity> listGoods = new ArrayList<>();
                            listGoods.add(entity);
                            map.put(entity.getSeller(),listGoods);
                        }

                    }
                });

                for(Map.Entry<Long,List<GoodsEntity>> entry : map.entrySet()){
                    // TO DO 定时到期下架消息发送
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    List<String> sender = new ArrayList<>();
                    sender.add(entry.getKey()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost+"cr12g-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=2&lowerTime="+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                    String mobileUrl = baseHost+"cr12g-panhuo-mobile/#/goodsManage?tab=1&userid={userid}";
                    String subject = "您上架的物资有【"+entry.getValue().size()+"】件今日到期自动下架";
                    String content = "您上架的物资有【"+entry.getValue().size()+"】件今日到期自动下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);


                    logger.info("物资上架到期(物资部相关指定回收人员)消息发送>----------");
                    logger.info("发送信息给物资部相关指定回收人员:>----------" + sender+baseHost);
                    for (GoodsEntity goodsEntity : entry.getValue()) {
                        //物资上架到期(物资上架人)
                        logger.info("物资上架到期(物资上架人)消息发送>----------");
                        List<String> sender1 = new ArrayList<>();
                        sender1.add(goodsEntity.getSeller()+"");
                        String formurl1 = baseHost+"cr12g-panhuo-frontend/#/assetMarket/marketDetails?id="+goodsEntity.getId();
                        String mobileUrl1 = baseHost+"cr12g-panhuo-mobile/#/marketIndex/marketViewCard?id="+goodsEntity.getId()+"&userid={userid}";
                        String subject1 = "【"+goodsEntity.getAddressName()+"+"+goodsEntity.getMaterialName()+"】上架长时间未被购买,已经进入待回收状态";
                        String content1 = "【"+goodsEntity.getAddressName()+"+"+goodsEntity.getMaterialName()+"】上架长时间未被购买,已经进入待回收状态,<a href=" + '"' + formurl1 + '"' + ">点击查看</a>";
                        this.sendMsg(messageType, sender1, "notice", subject1, content1,mobileUrl1);


                        logger.info("发送信息给物资上架人:>----------" + sender+baseHost);
                        //物资上架到期(物资部相关指定回收人员)
                        List<String> sender2 = new ArrayList<>();
                        sender2.add(goodsEntity.getLower()+"");
                        String formurl2 = baseHost+"cr12g-panhuo-frontend/#/recovery/recoveryAsset?id="+goodsEntity.getId();
                        String mobileUrl2 = baseHost+"cr12g-panhuo-mobile/#/appoint/appointCard?id="+goodsEntity.getId()+"&userid={userid}";
                        String subject2 = "【"+goodsEntity.getAddressName()+"+"+goodsEntity.getMaterialName()+"】上架长时间未被购买,请指定分公司回收";
                        String content2 = "【"+goodsEntity.getAddressName()+"+"+goodsEntity.getMaterialName()+"】上架长时间未被购买,请指定分公司回收,<a href=" + '"' + formurl2 + '"' + ">点击查看</a>";
                        this.sendMsg(messageType, sender2, "notice", subject2, content2,mobileUrl2);

                    }


                }

                if(CollectionUtils.isNotEmpty(listUp)){
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }

    public static void main(String[] args) {
        Calendar calendar2 = Calendar.getInstance();
        /* HOUR_OF_DAY 指示一天中小时 */
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        System.out.println();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", url);
            weixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * pc端，首页统计分析
     */
    @RequestMapping(value = "/orgStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportVO> orgStatistics(Long orgId) {
        ReportVO res = service.orgStatistics(orgId);
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * pc端，期间对比分析
     */
    @RequestMapping(value = "/periodStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> periodStatistics() {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.periodStatistics(commonOrgIds);
        return  CommonResponse.success("查询成功！",res);
    }
    /**
     * pc端，比例分析
     */
    @RequestMapping(value = "/proportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> proportion(int type) {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.proportion(commonOrgIds,type);
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * 下级单位使用分析
     */
    @RequestMapping(value = "/subordinateReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> subordinateReport() {
        List<ReportVO> res = new ArrayList<>();
        CommonResponse<List<OrgVO>> childrenOrg = orgApi.getDirectChildrenByPid(InvocationInfoProxy.getOrgId(), null);
        if(CollectionUtils.isNotEmpty(childrenOrg.getData())){
            childrenOrg.getData().forEach(e -> {
                ReportVO vo = service.orgStatistics(e.getId());
                vo.setOrgName(e.getName());
                res.add(vo);
            });
        }
        return  CommonResponse.success("查询成功！",res);
    }


    /**
     * @Description update 定时更新待指定
     */
    @RequestMapping(value = "/updateGoodsStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse updateGoodsStatus(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+day+"----");
        logger.debug("参数----"+day);
        if(day>=0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, 0);
            lambdachange.eq(GoodsEntity::getAssetBelongType,0);//归属类型为  项目
            List<GoodsEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                List<GoodsEntity> listUp = new ArrayList<>();
                Map<Long,List<GoodsEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,entity.getId()));
                    queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
                    List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
                    if(null==listOrder||listOrder.size()<=0){  //不存在未完成订单，可改为待指定
                        logger.debug("开始设置待指定----");
                        entity.setStatus(3);//待回收
                        entity.setRecoveryType(0);//待指定回收
                        listUp.add(entity);
                    }
                });
                if(CollectionUtils.isNotEmpty(listUp)){
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }

    /**
     * @Description newGoods 定时集市上新提醒
     */
    @RequestMapping(value = "/newGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse newGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+day+"----");
        String role = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(1).getString("value");
        logger.info("获取到的参数是："+role+"----");
        if (day>0){
            Calendar calendar = Calendar.getInstance();
            Calendar calendar1 = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - day);
            calendar1.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String format = df.format(calendar.getTime());
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            logger.info((df.format(calendar1.getTime())+"上新创建时间" + df.format(calendar.getTime())));
            //获取上新数据
            LambdaQueryWrapper<GoodsEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(GoodsEntity::getStatus, 0)
                    .lt(GoodsEntity::getCreateTime,df.format(calendar.getTime()))
                    .gt(GoodsEntity::getCreateTime,df.format(calendar1.getTime()));
            List<GoodsEntity> list= service.list(wrapper);
            if (list.size()>0){
                String[] roles = role.split(",");
                List<String> roleList= Arrays.asList(roles);
                List<UserVO> data = userApi.findAllUserByRoleNameList(roleList).getData();
                for (UserVO userVO : data) {
                    // 集市上新提醒消息发送
                    logger.info("集市上新提醒消息发送>----------");
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    List<String> sender = new ArrayList<>();
                    sender.add(userVO.getId()+"");
                    logger.info("发送信息给项目物资负责人:>----------" + userVO.getId()+baseHost);
                    String formurl = baseHost+"cr12g-panhuo-frontend/#/assetMarket";
                    String mobileUrl = baseHost+"cr12g-panhuo-mobile/#/marketIndex"+"&userid={userid}";
                    String subject = "闲置资源库昨日新增【"+list.size()+"】个物资";
                    String content = "闲置资源库昨日新增闲置资源库昨日新增【"+list.size()+"】个物资,请关注。<a href=" + '"' + formurl + '"' + ">点击查看</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }
}
