package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.mapper.AllotMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 调拨单
 * 
 * @author generator
 * 
 */
@Service("allotService")
public class AllotServiceImpl extends BaseServiceImpl<AllotMapper, AllotEntity> implements IAllotService{

    private static final String PANHUO_ZC = "ASSET_DD";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    @Override
    public AllotVO saveAllot(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = BeanMapper.map(vo, AllotEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        //ZCDB资产调拨（负） 订单完成后生成调拨单，并且插入一条记录  TurnoverTypeEnum
        TurnoverRecordEntity saveEntity = BeanMapper.map(entity, TurnoverRecordEntity.class);
        if(0==entity.getOrderType()){
            saveEntity.setSourceType(TurnoverTypeEnum.资产调拨.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.资产调拨.getName());
        }else{
            saveEntity.setSourceType(TurnoverTypeEnum.资产租赁.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.资产租赁.getName());
        }
        saveEntity.setSourceDate(entity.getCreateTime());
        saveEntity.setSourceId(entity.getId());
        saveEntity.setTon(entity.getCapacity());
        saveEntity.setSourceDetailId(entity.getGoodsId());//目前放商品主键
        saveEntity.setOrgId(entity.getSellOrg()); //出售方 组织  项目
        saveEntity.setOrgName(entity.getSellOrgName());
        saveEntity.setProjectId(entity.getSellProject());
        saveEntity.setProjectName(entity.getSellProjectName());
        saveEntity.setPrice(entity.getPrice());
        saveEntity.setTotalMoney(entity.getAmount());
        saveEntity.setNum(BigDecimal.ZERO.subtract(entity.getNums()==null?BigDecimal.ZERO:entity.getNums()));
        if (entity.getSellProject() != null && entity.getSellProject() > 0) {
            saveEntity.setAssetBelongType(0);
        } else {
            saveEntity.setAssetBelongType(1);
            saveEntity.setBelongOrgId(entity.getSellOrg());
            saveEntity.setBelongOrgName(entity.getSellOrgName());
        }
        turnoverRecordService.save(saveEntity);

        AllotVO resvo = BeanMapper.map(entity, AllotVO.class);
        return resvo;
    }
    @Override
    public AllotVO selectByMaterialName(Long projectId,Long orgId, String materialName) {
        return baseMapper.selectByMaterialName(projectId,orgId,materialName);
    }

    @Override
    public List<AllotVO> queryDetail(Long id, String materialName) {
        return baseMapper.queryDetail(id,materialName);
    }

    @Override
    public List<AllotVO> selectMaterialName(String materialName) {
        return baseMapper.selectMaterialName(materialName);
    }

    @Override
    public List<AllotVO> queryDetailByGoodId(Long id, String materialName) {
        return baseMapper.queryDetailByGoodId(id,materialName);
    }

    @Override
    public void saveAllotRecovery(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = BeanMapper.map(vo, AllotEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
    }
}
