package com.ejianc.business.bpmana.api;

import com.ejianc.business.bpmana.hystrix.UserBHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC用户接口
 *
 * @author squn
 *
 */
@FeignClient(name= "cscec5b-bpmana-web", url="${common.env.feign-client-url}", path="cscec5b-bpmana-web", fallback = UserBHystrix.class)
public interface IUserBApi {

	/**
	 * 更新资源库用户信息权限
	 * @return
	 */
	@GetMapping(value = "/api/user/updateUserAuth")
	public CommonResponse<Boolean> updateUserAuth(@RequestParam(required = true) String userId,
												   @RequestParam(required = true) String status);

}
