package com.ejianc.business.bpmana.controller;

import com.ejianc.business.bpmana.service.ICorpTreeService;
import com.ejianc.business.bpmana.util.TreeNodeBUtil;
import com.ejianc.business.bpmana.vo.CorpVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * [我的钢铁网] 价格查询
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("orgTree")
public class CorpTreeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ICorpTreeService service;

    /**
     * 根据用户过滤组织权限
     *
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getCorpByPkUser", method = RequestMethod.GET)
    @ResponseBody
    public List<CorpVO> getCorpByPkUser(@RequestParam("userId") String userId) throws Exception {
        List<CorpVO> corpVOList = service.getCorpByPkUser(userId);                        // 获取人员所在组织；
        return TreeNodeBUtil.buildTree(corpVOList);
    }

}
