package com.ejianc.business.bpmana.controller;

import com.ejianc.business.bpmana.service.IUserService;
import com.ejianc.business.bpmana.util.TreeNodeBUtil;
import com.ejianc.business.bpmana.vo.CorpVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 平台用户信息更新接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("user")
public class UserController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IUserService service;

    /**
     * 资源库中，用户权限设置
     *
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/updateUserAuth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> updateUserAuth(@RequestParam String userId, String status ) {
        return CommonResponse.success(service.updateUserAuth(userId, status));
    }

}
