package com.ejianc.business.bpmana.controller.api;

import com.ejianc.business.bpmana.service.IUserService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/user/")
public class UserBApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IUserService service;

	/**
	 * 资源库中，用户权限设置
	 *
	 * @param
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/updateUserAuth", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Boolean> updateUserAuth(@RequestParam String userId, String status ) {
		return CommonResponse.success(service.updateUserAuth(userId, status));
	}
}
