package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CalBodyHystrix;
import com.ejianc.business.dataexchange.vo.CalBodyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 库存组织参照接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CalBodyHystrix.class)
public interface ICalBodyApi {

	/**
	 * 库存组织参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/queryCalBodyRef")
	public CommonResponse<CalBodyVO> queryCalBodyRef( @RequestParam(value = "pkCorp", required = false) String pkCorp,
													  @RequestParam(defaultValue = "1") Integer pageNumber,
													  @RequestParam(defaultValue = "10") Integer pageSize,
													  @RequestParam(value = "condition", required = false) String condition,
													  @RequestParam(value = "searchText", required = false) String searchText);

}
