package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CmContractHystrix;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 物资合同接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CmContractHystrix.class)
public interface ICmContractApi {

	/**
	 * 仓库参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/queryMatContractRef")
	public CommonResponse<CmContract> queryMatContractRef(
            @RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

}
