package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.PurorgHystrix;
import com.ejianc.business.dataexchange.vo.Purorg;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 采购组织参照接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = PurorgHystrix.class)
public interface IPurorgApi {

	/**
	 * 采购组织参照查询
	 * @return
	 */
	@GetMapping(value = "/api/queryRdclRef")
	public CommonResponse<IPage<Purorg>> queryCalBodyRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText);

}
