package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CustHystrix;
import com.ejianc.business.dataexchange.vo.Areacl;
import com.ejianc.business.dataexchange.vo.Cubas;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC供应商接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CustHystrix.class)
public interface ICustApi {



	/**
	 * NC供应商同步查询
	 * @return
	 */
	@GetMapping(value = "/api/cust/list")
	public CommonResponse<List<Cubas>> queryCustByTs(@RequestParam(required = true) String ts,
														@RequestParam(value = "pkCorp", required = false) String pkCorp);

	/**
	 * NC供应商同步查询（区间）
	 * @return
	 */
	@GetMapping(value = "/api/cust/listByQj")
	public CommonResponse<List<Cubas>> queryCustByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
													 @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow,
													 @RequestParam(value = "pkCorp", required = false) String pkCorp);

	/**
	 * NC地区分类同步查询
	 * @return
	 */
	@GetMapping(value = "/api/areacl/list")
	public CommonResponse<List<Areacl>> queryAreaclByTs(@RequestParam(required = true) String ts );


}
