package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CmContractInfoHystrix;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 合同参照接口
 * 
 * @author sunq
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CmContractInfoHystrix.class)
public interface ICmContractInfoApi {

	/**
	 * 库存组织参照查询
	 * @param pkContract	合同主键：根据合同主键查询合同Info
	 * @return
	 */
	@GetMapping(value = "/api/queryCmContractInfoRef")
	public CommonResponse<CmContractInfoVO> queryCmContractInfoRef(@RequestParam(value = "pkContract", required = false) String pkContract,
																@RequestParam(defaultValue = "1") Integer pageNumber,
																@RequestParam(defaultValue = "10") Integer pageSize,
																@RequestParam(value = "condition", required = false) String condition,
																@RequestParam(value = "searchText", required = false) String searchText);

}
