package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.CmContractInfoHystrix;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 合同参照接口
 * 
 * @author sunq
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CmContractInfoHystrix.class)
public interface ICmContractInfoApi {

	/**
	 * 库存组织参照查询
	 * @param pkContract	合同主键：根据合同主键查询合同Info
	 * @return
	 */
	@GetMapping(value = "/api/querySubCmContractInfoRef")
	public CommonResponse<IPage<CmContractInfoVO>> querySubCmContractInfoRef(@RequestParam(value = "pkContract", required = false) String pkContract,
																		  @RequestParam(defaultValue = "1") Integer pageNumber,
																		  @RequestParam(defaultValue = "10") Integer pageSize,
																		  @RequestParam(value = "condition", required = false) String condition,
																		  @RequestParam(value = "searchText", required = false) String searchText);

	@GetMapping(value = "queryMatContractInfoRef")
	public CommonResponse<IPage<CmContractInfoVO>> queryMatContractInfoRef(
			@RequestParam(value = "pkContract", required=false) String pkContract,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 租赁合同，根据合同主键查询合同清单
	 * @param pkContract	合同主键：根据租赁合同主键查询合同Info
	 * @return
	 */
	@GetMapping(value = "/api/queryLeaseContractInfoById")
	public CommonResponse<List<CmContractInfoVO>> queryLeaseContractInfoById(@RequestParam(value = "pkContract") String pkContract);

	/**
	 * 物资合同，根据合同主键查询合同清单
	 * @param pkContract	合同主键：根据物资合同主键查询合同Info
	 * @return
	 */
	@GetMapping(value = "/api/queryMatContractInfoById")
	public CommonResponse<List<CmContractInfoVO>> queryMatContractInfoById(@RequestParam(value = "pkContract") String pkContract);

}
