package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.CorpHystrix;
import com.ejianc.business.dataexchange.vo.Corp;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC公司接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CorpHystrix.class)
public interface ICorpApi {

	/**
	 * NC公司参照查询
	 * @return
	 */
	@GetMapping(value = "/api/queryNCCorpRef")
	public CommonResponse<IPage<Corp>> queryNCCorpRef(
			@RequestParam(defaultValue = "@@@@") String fathercorp,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText);


	/**
	 * NC公司同步查询
	 * @return
	 */
	@GetMapping(value = "/api/corp/list")
	public CommonResponse<List<Corp>> queryNCCorpByTs(@RequestParam(required = true) String ts);

}
