/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.IInvbasService;
import com.ejianc.business.dataexchange.service.IInvclService;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invbas;
import com.ejianc.business.dataexchange.vo.Invcl;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
public class InvApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvclService invclService;
    @Autowired
    private IInvbasService invbasService;
    @Autowired
    private IInvmanService invmanService;

    @GetMapping(value={"/invcl/list"})
    public CommonResponse<List<Invcl>> queryNCInvclByTs(@RequestParam(required=true) String ts) {
        List<Invcl> invcls = this.invclService.queryNCInvclsByTs(ts);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", invcls);
    }

    @GetMapping(value={"/invbas/list"})
    public CommonResponse<List<Invbas>> queryNCInvbasByTs(@RequestParam(required=true) String ts) {
        List<Invbas> invbass = this.invbasService.queryNCInvbassByTs(ts);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u57fa\u672c\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", invbass);
    }

    @GetMapping(value={"/invbas/listByQj"})
    public CommonResponse<List<Invbas>> queryNCInvbasByQj(@RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) Integer beginRow, @RequestParam(required=false) Integer endRow) {
        List<Invbas> invbass = this.invbasService.queryNCInvbassByQj(beginTime, endTime, beginRow, endRow);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u57fa\u672c\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", invbass);
    }

    @GetMapping(value={"/invman/list"})
    public CommonResponse<List<Invman>> queryNCInvmanByTs(@RequestParam(required=true) String ts, @RequestParam(required=false) String pkCorp) {
        List<Invman> invmans = this.invmanService.selectListAll(ts, pkCorp);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u7ba1\u7406\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", invmans);
    }

    @GetMapping(value={"/invman/listByQj"})
    public CommonResponse<List<Invman>> queryNCInvmanByQj(@RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) Integer beginRow, @RequestParam(required=false) Integer endRow, @RequestParam(required=false) String pkCorp) {
        this.logger.info("imvman is " + beginTime + "@@" + endTime + "@@" + beginRow + "@@" + endRow + "@@" + pkCorp);
        List<Invman> invmans = this.invmanService.selectListAllByQj(beginTime, endTime, beginRow, endRow, pkCorp);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u7ba1\u7406\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", invmans);
    }
}

