/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.ICorpUserService;
import com.ejianc.business.dataexchange.service.IUserService;
import com.ejianc.business.dataexchange.vo.CorpUser;
import com.ejianc.business.dataexchange.vo.User;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
public class UserApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserService userService;
    @Autowired
    private ICorpUserService corpUserService;

    @GetMapping(value={"/user/list"})
    public CommonResponse<List<User>> queryUsersByTs(@RequestParam(required=true) String ts) {
        List<User> listres = this.userService.selectListFromOriginalData(ts);
        return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", listres);
    }

    @GetMapping(value={"/user/listByQj"})
    public CommonResponse<List<User>> queryUsersByQj(@RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime) {
        List<User> listres = this.userService.selectListFromOriginalDataByQj(beginTime, endTime);
        return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", listres);
    }

    @GetMapping(value={"/corpuser/listByQj"})
    public CommonResponse<List<CorpUser>> queryCorpUserByQj(@RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) Integer beginRow, @RequestParam(required=false) Integer endRow) {
        this.logger.info("beginRow is ------>" + beginRow);
        this.logger.info("endRow is ------>" + endRow);
        List<CorpUser> listres = this.corpUserService.queryNCCorpUsersByQj(beginTime, endTime, beginRow, endRow);
        return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u6743\u9650\u7684\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", listres);
    }

    @GetMapping(value={"/corpuser/list"})
    public CommonResponse<List<CorpUser>> queryCorpUserByTs(@RequestParam(required=true) String ts) {
        List<CorpUser> listres = this.corpUserService.queryNCCorpUsersByTs(ts);
        return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u6743\u9650\u7684\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", listres);
    }
}

