package com.ejianc.business.dataexchange.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.UserMapper;
import com.ejianc.business.dataexchange.service.IUserService;
import com.ejianc.business.dataexchange.vo.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("userService")
public class UserService extends ServiceImpl<UserMapper, User> implements IUserService {

    @Override
    public List<User> selectListFromOriginalData(String ts) {
        List<User>  users = baseMapper.selectListFromOriginalData(ts);
        if (users != null && !users.isEmpty()) {
            List<User> jtusers = users.stream()
                    .filter(u -> StringUtils.isBlank(u.getPkCorp()) && u.getPkCorp().equals("0001"))
                    .collect(Collectors.toList());
            jtusers.stream().forEach(u -> u.setPkCorp("1001"));
        }
        return users;
    }

    @Override
    public List<User> selectListFromOriginalDataByQj(String beginTime, String endTime) {
       // return baseMapper.selectListFromOriginalDataByQj(beginTime, endTime);
        List<User>  users = baseMapper.selectListFromOriginalDataByQj(beginTime, endTime);
        if (users != null && !users.isEmpty()) {
            List<User> jtusers = users.stream()
                    .filter(u -> StringUtils.isBlank(u.getPkCorp()) && u.getPkCorp().equals("0001"))
                    .collect(Collectors.toList());
            jtusers.stream().forEach(u -> u.setPkCorp("1001"));
        }
        return users;
    }
}
