package com.ejianc.business.dataexchange.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CmContractMapper;
import com.ejianc.business.dataexchange.service.ICmContractService;
import com.ejianc.business.dataexchange.vo.CmContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 物资合同 服务实现类
 * </p>
 *
 * @author Brin
 * @since 2020-10-30 11:50:23
 */
@Service("cmContractService")
public class CmContractService extends ServiceImpl<CmContractMapper, CmContract> implements ICmContractService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    public List<CmContract> queryMatCmContract(Page<CmContract> page, QueryWrapper queryWrapper, Long supplierId ,String pkCorp, String pkBilltype, String pkProject) {
        logger.info("------------ service 公司条件 ,{}",pkCorp);
        List<CmContract> list = baseMapper.queryPage(page, queryWrapper, supplierId, pkCorp, pkBilltype, pkProject);
        return list;
    }

    public CmContract queryMatContractById( String contractId) {
        logger.info("------------ service 公司条件 ,{}",contractId);
        CmContract entity = baseMapper.queryMatContractById(contractId);
        return entity;
    }

    public List<CmContract> querySubCmContract(Page<CmContract> page, QueryWrapper queryWrapper, Long supplierId ,String pkCorp) {
        List<CmContract> list = baseMapper.querySubPage(page, queryWrapper, supplierId, pkCorp);
        return list;
    }
}

