package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CtplanBMapper;
import com.ejianc.business.dataexchange.service.ICtplanBService;
import com.ejianc.business.dataexchange.vo.CtplanB;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 物料分类接口 服务实现类
 * </p>
 *
 * @author Brin
 * @since 2020-11-04 13:58:17
 */
@Service("ctplanBService")
public class CtplanBService extends ServiceImpl<CtplanBMapper, CtplanB> implements ICtplanBService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<CtplanB> queryNCCtPlanDetailByTs(String ts) {
        return baseMapper.queryNCCtPlanDetailByTs(ts);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime, String tenantId, String pkCorp) {
        logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank(pkCorp));
        if (StringUtils.isNotBlank(pkCorp)) {
            List<CtplanB> ctplanBList = baseMapper.queryNCCtPlanDetailByQj(beginTime, endTime, pkCorp);
            if(CollectionUtils.isNotEmpty(ctplanBList)){
                String json = JSONObject.toJSONString(ctplanBList);
                logger.info("put redis is " + pkCorp + "ctplanBList is " + json);
                redisTemplate.opsForValue().set(pkCorp + "###ctplan", json,6000, TimeUnit.SECONDS);
            }
        }else{
            CommonResponse<List<String>> orgResponse = orgApi.findMainOrgByTenantId(Long.valueOf(tenantId));
            logger.info("before put time is " + new Date());
            if(CollectionUtils.isNotEmpty(orgResponse.getData())) {
                for (String pk : orgResponse.getData()) {
                    if (StringUtils.isBlank(pk)) {
                        continue;
                    }
                    List<CtplanB> ctplanBList = baseMapper.queryNCCtPlanDetailByQj(beginTime, endTime, pk);
                    if(CollectionUtils.isNotEmpty(ctplanBList)){
                        String json = JSONObject.toJSONString(ctplanBList);
                        logger.info("put redis is " + pk + "ctplanBList  size is " + ctplanBList.size());
                        redisTemplate.opsForValue().set(pk + "###ctplan", json,6000, TimeUnit.SECONDS);
                    }
                }
            }
            logger.info("end put time is " + new Date());
        }
        return CommonResponse.success("redis消耗材总控数据成功！");
    }
}

