/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.InvmanMapper;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="invmanService")
public class InvmanService
extends ServiceImpl<InvmanMapper, Invman>
implements IInvmanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<Invman> selectListAll(String ts, String pkCorp) {
        return ((InvmanMapper)this.baseMapper).queryNCInmansByTs(ts, pkCorp);
    }

    @Override
    public List<Invman> selectListAllByQj(String beginTime, String endTime, Integer beginRow, Integer endRow, String pkCorp) {
        return ((InvmanMapper)this.baseMapper).queryNCInmansByQj(beginTime, endTime, beginRow, endRow, pkCorp);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime, String tenantId, String pkCorp) {
        this.logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank((CharSequence)pkCorp));
        if (StringUtils.isNotBlank((CharSequence)pkCorp)) {
            List<Invman> invmanList = ((InvmanMapper)this.baseMapper).queryInmansByQj(beginTime, endTime, pkCorp);
            if (CollectionUtils.isNotEmpty(invmanList)) {
                String json = JSONObject.toJSONString(invmanList);
                this.logger.info("put redis is " + pkCorp + "invmanList is " + json);
                this.redisTemplate.opsForValue().set((Object)(pkCorp + "@@@&&&"), (Object)json, 6000L, TimeUnit.SECONDS);
            }
        } else {
            CommonResponse orgResponse = this.orgApi.findMainOrgByTenantId(Long.valueOf(tenantId));
            this.logger.info("before put time is " + new Date());
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgResponse.getData()))) {
                for (String pk : (List)orgResponse.getData()) {
                    List<Invman> invmanList;
                    if (StringUtils.isBlank((CharSequence)pk) || !CollectionUtils.isNotEmpty(invmanList = ((InvmanMapper)this.baseMapper).queryInmansByQj(beginTime, endTime, pk))) continue;
                    String json = JSONObject.toJSONString(invmanList);
                    this.logger.info("put redis is " + pk + "invmanList is " + json);
                    this.redisTemplate.opsForValue().set((Object)(pk + "@@@&&&"), (Object)json, 6000L, TimeUnit.SECONDS);
                }
            }
            this.logger.info("end put time is " + new Date());
        }
        return CommonResponse.success((String)"redis\u7269\u6599\u7ba1\u7406\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01");
    }
}

