package com.ejianc.business.dataexchange.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.service.ICorpDeptPathService;
import com.ejianc.business.dataexchange.service.IProjectService;
import com.ejianc.business.dataexchange.vo.Project;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping("/api/")
public class CorpDetpPathApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICorpDeptPathService projectService;


    /**
     * NC项目同步查询
     * @return
     */
    @GetMapping(value = "/corpdept/path")
    public CommonResponse<String> queryProjectPath(@RequestParam(required = false) String projectcode,
                                                   @RequestParam(required = false) String projectname) {
        QueryParam queryParam = new QueryParam();
//        List<String> fuzzyFields = queryParam.getFuzzyFields();
//        fuzzyFields.add("code");
//        fuzzyFields.add("name");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        String path = projectService.selectProjectFilePath(null,projectcode,projectname);

        return CommonResponse.success("查询项目目录成功！",path);
    }

}
