/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CtplanBMapper;
import com.ejianc.business.dataexchange.service.ICtplanBService;
import com.ejianc.business.dataexchange.vo.CtplanB;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="ctplanBService")
public class CtplanBService
extends ServiceImpl<CtplanBMapper, CtplanB>
implements ICtplanBService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<CtplanB> queryNCCtPlanDetailByTs(String ts) {
        return ((CtplanBMapper)this.baseMapper).queryNCCtPlanDetailByTs(ts);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime, String tenantId, String pkCorp) {
        this.logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank((CharSequence)pkCorp));
        if (StringUtils.isNotBlank((CharSequence)pkCorp)) {
            List<CtplanB> ctplanBList = ((CtplanBMapper)this.baseMapper).queryNCCtPlanDetailByQj(beginTime, endTime, pkCorp);
            if (CollectionUtils.isNotEmpty(ctplanBList)) {
                String json = JSONObject.toJSONString(ctplanBList);
                this.logger.info("put redis is " + pkCorp + "ctplanBList is " + json);
                this.redisTemplate.opsForValue().set((Object)(pkCorp + "###ctplan"), (Object)json, 6000L, TimeUnit.SECONDS);
            }
        } else {
            CommonResponse orgResponse = this.orgApi.findMainOrgByTenantId(Long.valueOf(tenantId));
            this.logger.info("before put time is " + new Date());
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgResponse.getData()))) {
                for (String pk : (List)orgResponse.getData()) {
                    List<CtplanB> ctplanBList;
                    if (StringUtils.isBlank((CharSequence)pk) || !CollectionUtils.isNotEmpty(ctplanBList = ((CtplanBMapper)this.baseMapper).queryNCCtPlanDetailByQj(beginTime, endTime, pk))) continue;
                    String json = JSONObject.toJSONString(ctplanBList);
                    this.logger.info("put redis is " + pk + "ctplanBList  size is " + ctplanBList.size());
                    this.redisTemplate.opsForValue().set((Object)(pk + "###ctplan"), (Object)json, 6000L, TimeUnit.SECONDS);
                }
            }
            this.logger.info("end put time is " + new Date());
        }
        return CommonResponse.success((String)"redis\u6d88\u8017\u6750\u603b\u63a7\u6570\u636e\u6210\u529f\uff01");
    }
}

