package com.ejianc.business.datalake.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.bean.MarketPriceEntity;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * [我的钢铁网] 价格查询
 *
 * @author generator
 *
 */
@Mapper
public interface MysteelMapper extends BaseCrudMapper<MarketPriceEntity> {

    List<RegionRefVO> getRegionRef1(Page<RegionRefVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("materialName") String materialName, @Param("checkDate")String checkDate);
    List<BrandRefVO> getBrandRef1(Page<BrandRefVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("materialName") String materialName, @Param("region") String region, @Param("checkDate")String checkDate);

    BigDecimal getRecomPrice1(@Param("region")String region, @Param("brand")String brand, @Param("materialName")String materialName, @Param("checkDate")String checkDate);

    List<MarketPriceVO> getMarketPrice1(@Param("region")String region, @Param("brand")String brand, @Param("materialName")String materialName, @Param("checkDate")String checkDate);

}
