package com.ejianc.business.datalake.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.bean.MarketPriceEntity;
import com.ejianc.business.datalake.mapper.MysteelMapper;
import com.ejianc.business.datalake.service.IMysteelService;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import org.springframework.stereotype.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * [我的钢铁网] 价格查询
 *
 * @author generator
 *
 */
@Service("mysteelService")
public class MysteelServiceImpl extends BaseServiceImpl<MysteelMapper, MarketPriceEntity> implements IMysteelService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<RegionRefVO> getRegionRef1(Page<RegionRefVO> page, QueryWrapper wrapper, String materialName, String checkDate) {
        List<RegionRefVO> list = baseMapper.getRegionRef1(page, wrapper,materialName, checkDate);
//        // 如果当天的价格没有发布，则查询前一天的
//        if (list == null) {
//            String beforeDay = this.getBeforeDay(checkDate);
//            list = this.getRegionRef1(page, wrapper, materialName, beforeDay);
//        }
        return list;
    }

    @Override
    public List<BrandRefVO> getBrandRef1(Page<BrandRefVO> page, QueryWrapper wrapper, String materialName, String region, String checkDate) {
        List<BrandRefVO> list = baseMapper.getBrandRef1(page, wrapper,materialName, region, checkDate);
//        // 如果当天的价格没有发布，则查询前一天的
//        if (list == null) {
//            String beforeDay = this.getBeforeDay(checkDate);
//            list = this.getBrandRef1(page, wrapper,materialName, region, beforeDay);
//        }
        return list;
    }

    @Override
    public BigDecimal getRecomPrice1(String region, String brand, String materialName, String checkDate) {
        BigDecimal price = baseMapper.getRecomPrice1(region, brand, materialName, checkDate);
//        // 如果当天的价格没有发布，则查询前一天的
//        if (price == null) {
//            String beforeDay = this.getBeforeDay(checkDate);
//            price = this.getRecomPrice1(region, brand, materialName, beforeDay);
//        }
        return price;
    }

    @Override
    public List<MarketPriceVO> getMarketPrice1(String region, String brand, String materialName, String checkDate) {
        List<MarketPriceVO> priceList = baseMapper.getMarketPrice1(region, brand, materialName, checkDate);
//        // 如果当天的价格没有发布，则查询前一天的
//        if (priceList == null) {
//            String beforeDay = this.getBeforeDay(checkDate);
//            priceList = this.getMarketPrice1(region, brand, materialName, beforeDay);
//        }
        return priceList;
    }

    /**
     @param: 入参是当前时间2020-03-01
     @return:返参是前一天的日期,理应为2020-02-29(闰年)
     */
    private String getBeforeDay(String dateTime){
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try{
            date=simpleDateFormat.parse(dateTime);
        }catch (ParseException e){
            logger.error("String转Date日期失败:",e);
        }
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(date);
        //往前一天
        calendar.add(Calendar.DAY_OF_MONTH,-1);
        return simpleDateFormat.format(calendar.getTime());
    }

    /**
     *字符串的日期格式的计算
     * @param smdate 较小的时间
     * @param bdate  较大的时间
     * @return 相差天数
     */
    public int daysBetween(String smdate,String bdate) {
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        try{
            cal.setTime(sdf.parse(smdate));
        }catch (ParseException e){
            logger.error("String转Date日期失败:",e);
        }
        long time1 = cal.getTimeInMillis();
        try{
            cal.setTime(sdf.parse(bdate));
        }catch (ParseException e){
            logger.error("String转Date日期失败:",e);
        }
        long time2 = cal.getTimeInMillis();
        long between_days=(time2-time1)/(1000*3600*24);

        return Integer.parseInt(String.valueOf(between_days));
    }

}
