package com.ejianc.business.fbxt.grap.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.fbxt.grap.vo.GrapDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 进度计量实体
 * 
 * @author generator
 * 
 */
public class GrapVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态（审批必须字段）
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectSourceId; // 项目来源ID
    private String projectName; // 项目名称
    private Long cropId; // 项目所属组织id
    private String cropName; // 项目所属组织名称
    private String cropSourceId; // 项目所属组织来源id
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private String contractId; // 合同主键
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long supplierId; // 设备供应商
    private String supplierSourceId; // 供应商来源ID
    private String supplierName; // 供应商名称
    private Integer historyFlag; // 是否历史数据1-是，0-否
    private String historyId; // 来源主键
    private String historySystem; // 来源系统
    private Integer useState; // 是否已汇总，0-未汇总，1-已汇总
    private Integer saveState; // 保存状态（0-暂存态，1-保存态）
    private java.math.BigDecimal sumMny; // 总计金额
    private String construction; // 施工部位
    private String description; // 进度说明
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    private Long createUserId; // 创建者主键
    private String createUserName; // 创建者名称
    private Long sumGrapId; // 汇总进度台账主键
    private String billStateName; // 单据状态名称
    private String useStateName; // 汇总状态名称
    private String memo; // 备注
    private String source; // 记录来源 0供方 1自制
    private String sourceId; // 来源id
    private String feedback; // 存疑退回意见
    private String pkCreator;//编制人
    //确认人主键
    private String confirmer;
    //确认人姓名
    private String confirmer_name;
    //确认时间
    private String confirmer_data;

    public String getConfirmer() {
        return confirmer;
    }

    public void setConfirmer(String confirmer) {
        this.confirmer = confirmer;
    }

    public String getConfirmer_name() {
        return confirmer_name;
    }

    public void setConfirmer_name(String confirmer_name) {
        this.confirmer_name = confirmer_name;
    }

    public String getConfirmer_data() {
        return confirmer_data;
    }

    public void setConfirmer_data(String confirmer_data) {
        this.confirmer_data = confirmer_data;
    }

    public String getSource() {
        return source;
    }

    public String getFeedback() {
        return feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public String getPkCreator() {
        return pkCreator;
    }

    public void setPkCreator(String pkCreator) {
        this.pkCreator = pkCreator;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    private List<GrapDetailVO> detailList = new ArrayList<>(); // 进度计量子表实体

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    @ReferDeserialTransfer
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织名称
     */
    public String getCropName() {
        return cropName;
    }

    /**
     * 项目所属组织名称
     */
    public void setCropName(String cropName) {
        this.cropName = cropName;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }

    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商来源ID
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供应商来源ID
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 是否历史数据1-是，0-否
     */
    public Integer getHistoryFlag() {
        return historyFlag;
    }

    /**
     * 是否历史数据1-是，0-否
     */
    public void setHistoryFlag(Integer historyFlag) {
        this.historyFlag = historyFlag;
    }
    /**
     * 来源主键
     */
    public String getHistoryId() {
        return historyId;
    }

    /**
     * 来源主键
     */
    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }
    /**
     * 来源系统
     */
    public String getHistorySystem() {
        return historySystem;
    }

    /**
     * 来源系统
     */
    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }
    /**
     * 是否已汇总，0-未汇总，1-已汇总
     */
    public Integer getUseState() {
        return useState;
    }

    /**
     * 是否已汇总，0-未汇总，1-已汇总
     */
    public void setUseState(Integer useState) {
        this.useState = useState;
    }
    /**
     * 保存状态（0-暂存态，1-保存态）
     */
    public Integer getSaveState() {
        return saveState;
    }

    /**
     * 保存状态（0-暂存态，1-保存态）
     */
    public void setSaveState(Integer saveState) {
        this.saveState = saveState;
    }
    /**
     * 总计金额
     */
    public java.math.BigDecimal getSumMny() {
        return sumMny;
    }

    /**
     * 总计金额
     */
    public void setSumMny(java.math.BigDecimal sumMny) {
        this.sumMny = sumMny;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 进度说明
     */
    public String getDescription() {
        return description;
    }

    /**
     * 进度说明
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 创建者主键
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * 创建者主键
     */
    @ReferDeserialTransfer
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    /**
     * 创建者名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建者名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 汇总进度台账主键
     */
    public Long getSumGrapId() {
        return sumGrapId;
    }

    /**
     * 汇总进度台账主键
     */
    public void setSumGrapId(Long sumGrapId) {
        this.sumGrapId = sumGrapId;
    }
    /**
     * 单据状态名称
     */
    public String getBillStateName() {
        return billStateName;
    }
    /**
     * 单据状态名称
     */
    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    /**
     * 汇总状态名称
     */
    public String getUseStateName() {
        return useStateName;
    }

    /**
     * 汇总状态名称
     */
    public void setUseStateName(String useStateName) {
        this.useStateName = useStateName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
      * 进度计量子表实体
      */
     public List<GrapDetailVO> getDetailList() {
        return detailList;
     }

     /**
      * 进度计量子表实体
      */
     public void setDetailList(List<GrapDetailVO> detailList) {
        this.detailList = detailList;
     }
}
