package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;

/**
 * 用工申请实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("oddApply")
public class OddApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi orgApi;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOddApplyService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddApplyVO> saveOrUpdate(@RequestBody OddApplyVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddApplyVO> queryDetail(Long id) {
    	OddApplyEntity entity = service.selectById(id);
    	OddApplyVO vo = BeanMapper.map(entity, OddApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddApplyVO> vos) {
        service.removeByIds(vos.stream().map(OddApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // todo
        //申请时间，近三天，近一周，近一月
        //是否由我创建
        //是否登记

        IPage<OddApplyEntity> page = service.queryPage(param,false);
        IPage<OddApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询暂存
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryzcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryzcList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // todo
        //申请时间，近三天，近一周，近一月
        //是否由我创建
        //是否登记

        IPage<OddApplyEntity> page = service.queryPage(param,false);
        IPage<OddApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
