package com.ejianc.business.fbxt.odd.service.impl;

import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddApplyMapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;

/**
 * 用工申请实体
 * 
 * @author generator
 * 
 */
@Service("oddApplyService")
public class OddApplyServiceImpl extends BaseServiceImpl<OddApplyMapper, OddApplyEntity> implements IOddApplyService{
    private static final String ODD_APPLY = "ODD_APPLY";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<OddApplyVO>  saveOrUpdate(OddApplyVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddApplyEntity entity = null;
        String operateType = null;
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddApplyEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_APPLY,tenantId);
                if(billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, OddApplyEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getOrgId());
        if(!orgVo.isSuccess()) {
            return CommonResponse.error("列表查询失败, 查询组织信息失败！");
        }
        if(null!=orgVo.getData()){
            entity.setCropSourceId(orgVo.getData().getSourceId());
        }
        entity.setRegisterFlag(0);//未登记
        super.saveOrUpdate(entity, false);
    	OddApplyVO vo = BeanMapper.map(entity, OddApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
