package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapDetailService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.business.fbxt.util.UuidUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("grap") 
public class GrapBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IGrapService grapService;

	@Autowired
	private ISumGrapService sumGrapService;

	@Autowired
	private ISumGrapDetailService sumGrapDetailService;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		//是否被其他单据引用
//		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(res.isSuccess()) {//单据未被下游单据引用
//			return CommonResponse.success();
//		}else{
//			return CommonResponse.error(res.getMsg());
//		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		GrapEntity entity = grapService.selectById(billId);
		// 防止重复点击汇总
		if(entity.getSumGrapId() != null){
			List<GrapDetailEntity> detailList = entity.getDetailList();
			LambdaQueryWrapper<SumGrapEntity> wrapper = new LambdaQueryWrapper<>();
			wrapper.eq(SumGrapEntity::getContractId, entity.getContractId());
			wrapper.eq(SumGrapEntity::getBillState, 0);
			List<SumGrapEntity> sumGrapList = sumGrapService.list(wrapper);

			SumGrapVO sumGrapVO = null;
			Map<String, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-infoId，value-非末级VO
			Map<Long, SumGrapDetailVO> sumDetailMap = new HashMap<>();// 子表Map，key-id，value-所有子表VO
			if(CollectionUtils.isEmpty(sumGrapList)){
				// 新增进度台账
				sumGrapVO = this.getSumGrapVO(entity);// 构造主表VO
				// 子表
				if(CollectionUtils.isNotEmpty(detailList)){
					for(GrapDetailEntity detail : detailList){
						this.dealSumDetailMap(entity, detail, parentMap, sumDetailMap);
					}
				}
				sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
			} else {
				// 汇总进度台账
				SumGrapEntity sumGrapEntity = sumGrapService.selectById(sumGrapList.get(0).getId());
				sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
				sumGrapVO.setMemo(this.getSumStr(sumGrapVO.getMemo(), entity.getMemo()));// 汇总进度说明
				sumGrapVO.setSumMny(DecimalUtils.add(sumGrapVO.getSumMny(), entity.getSumMny()));// 汇总金额
				sumGrapVO.setSumApproveMny(DecimalUtils.add(sumGrapVO.getSumApproveMny(), entity.getSumMny()));// 汇总审批金额
				List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();
				for(SumGrapDetailVO vo : sumDetailList){
					if(vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getInfoId())){
						parentMap.put(vo.getInfoId(), vo);
					}
					if(!sumDetailMap.containsKey(vo.getId())){
						sumDetailMap.put(vo.getId(), vo);
					}
				}
				if(CollectionUtils.isNotEmpty(detailList)) {
					for (GrapDetailEntity detail : detailList) {
						this.dealSumDetailMap(entity, detail, parentMap, sumDetailMap);
					}
					sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
				}
			}
			sumGrapService.saveOrUpdate(sumGrapVO);
			// 防止entity污染，重新查询修改
			entity = grapService.selectById(billId);
			entity.setSumGrapId(sumGrapVO.getId());
			grapService.updateById(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 构造主表VO
	 * @param entity
	 * @return
	 */
	private SumGrapVO getSumGrapVO(GrapEntity entity) {
		SumGrapVO vo = new SumGrapVO();
		vo.setProjectId(entity.getProjectId());// 项目主键
		vo.setProjectName(entity.getProjectName());// 项目名称
		vo.setProjectSourceId(entity.getProjectSourceId());// 项目来源ID
		vo.setContractId(entity.getContractId());// 合同主键
		vo.setContractCode(entity.getContractCode());// 合同编码
		vo.setContractName(entity.getContractName());// 合同名称
		vo.setCropId(entity.getCropId());// 组织主键
		vo.setCropSourceId(entity.getCropSourceId());// 组织来源ID
		vo.setOrgId(entity.getOrgId());// 项目部主键
		vo.setOrgName(entity.getOrgName());// 项目部名称
		vo.setOrgSourceId(entity.getOrgSourceId());// 项目部来源ID
		vo.setSupplierId(entity.getSupplierId());// 供应商主键
		vo.setSupplierName(entity.getSupplierName());// 供应商名称
		vo.setSupplierSourceId(entity.getSupplierSourceId());// 供应商来源ID
		vo.setCreateUserId(InvocationInfoProxy.getUserid());// 制单人主键
		vo.setCreateUserName(sessionManager.getUserContext().getUserName());// 制单人名称
		// 汇总
		vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(entity.getCreateDate()));
		vo.setSumMny(entity.getSumMny());// 汇总金额
		vo.setSumApproveMny(entity.getSumMny());// 汇总审核金额
		vo.setMemo(entity.getMemo());// 进度说明
		return vo;
	}

	/**
	 * 构造子表VO
	 * @param entity
	 * @param detail
	 * @param parentMap
	 * @param sumDetailMap
	 */
	private void dealSumDetailMap(GrapEntity entity, GrapDetailEntity detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
		String infoId = detail.getInfoId();
		// 新增末级
		SumGrapDetailVO vo = new SumGrapDetailVO();
		vo.setGrapId(entity.getId());// 计量单主键
		vo.setGrapDetailId(detail.getId());// 计量单子表主键
		vo.setInfoId(detail.getInfoId());// 合同清单主键
//		vo.setInfoCode(detail.getInfoCode());// 合同清单编码
//		vo.setInfoName(detail.getInfoName());// 合同清单名称
//		vo.setUnit(detail.getUnit());// 单位
//		vo.setPrice(detail.getPrice());// 单价
		vo.setNum(detail.getNum());// 数量
		vo.setApproveNum(detail.getNum());// 审批数量
		vo.setMny(detail.getMny());// 金额
		vo.setApproveMny(detail.getMny());// 审批金额
		vo.setConstruction(entity.getConstruction());// 施工部位
		vo.setMemo(entity.getMemo());// 进度说明
		vo.setCommitUserId(entity.getCreateUserId());// 提交人主键
		vo.setCommitUserName(entity.getCreateUserName());// 提交人名称
		// 处理非末级VO
		Long parentId = null;
		SumGrapDetailVO parentVO = null;
		if(!parentMap.containsKey(infoId)){
			// 新增
			parentId = Long.valueOf(UuidUtil.getGuid());// 生成随机主键
			parentVO = new SumGrapDetailVO();
			parentVO.setId(parentId);// 主键
			parentVO.setInfoId(detail.getInfoId());// 合同清单主键
			parentVO.setInfoCode(detail.getInfoCode());// 合同清单编码
			parentVO.setInfoName(detail.getInfoName());// 合同清单名称
			parentVO.setUnit(detail.getUnit());// 单位
			parentVO.setPrice(detail.getPrice());// 单价
			parentVO.setNum(detail.getNum());// 数量
			parentVO.setApproveNum(detail.getNum());// 审批数量
			parentVO.setMny(detail.getMny());// 金额
			parentVO.setApproveMny(detail.getMny());// 审批金额
			parentVO.setConstruction(entity.getConstruction());// 施工部位
			parentVO.setLeafFlag(0);// 是否末级，0-否，1-是
			parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));// 序号
			parentMap.put(infoId, parentVO);
		} else {
			// 汇总
			parentVO = parentMap.get(infoId);
			parentId = parentVO.getId();
			parentVO.setNum(DecimalUtils.add(parentVO.getNum(), detail.getNum()));// 汇总数量
			parentVO.setApproveNum(DecimalUtils.add(parentVO.getApproveNum(), detail.getNum()));// 汇总审批数量
			parentVO.setMny(DecimalUtils.add(parentVO.getMny(), detail.getMny()));// 汇总金额
			parentVO.setApproveMny(DecimalUtils.add(parentVO.getApproveMny(), detail.getMny()));// 汇总审批金额
			String construction = this.getSumStr(parentVO.getConstruction(), entity.getConstruction());
			parentVO.setConstruction(construction);// 汇总施工部位
		}
		sumDetailMap.put(parentId, parentVO);// 放入非末级VO
		vo.setLeafFlag(1);// 是否末级，0-否，1-是
		vo.setParentId(parentId);// 父级主键
		vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));// 序号
		sumDetailMap.put(detail.getId(), vo);// 放入末级VO
	}

	/**
	 * 汇总字符串，去重并去空格
	 * @param sumStr
	 * @param str
	 * @return
	 */
	private String getSumStr(String sumStr, String str) {
		if(StringUtils.isNotEmpty(str)){
			str = str.replaceAll(" ", "");
		} else {
			return sumStr;
		}
		if(StringUtils.isNotEmpty(sumStr)){
			String[] strs = sumStr.split(",");
			Set<String> strSet = new HashSet<>(Arrays.asList(strs));
			if(!strSet.contains(str)){
				sumStr = sumStr + "," + str;
			}
			return sumStr;
		} else {
			return str;
		}
	}

	/**
	 * 获取子表末级排序
	 * @param map
	 * @param parentId
	 * @return
	 */
	private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
		int index = 1;
		for(SumGrapDetailVO vo : map.values()){
			if(parentId.equals(vo.getParentId())){
				index += 1;
			}
		}
		return index;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		GrapEntity entity = grapService.selectById(billId);
		// 防止重复点击汇总
		if(entity.getSumGrapId() != null){
			SumGrapEntity sumGrapEntity = sumGrapService.selectById(entity.getSumGrapId());
			SumGrapVO sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
			List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();

			Map<Long, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-id，value-非末级VO
			Map<Long, SumGrapDetailVO> sumDetailMap = new HashMap<>();// 子表Map，key-id，value-所有未删除子表VO
			if(CollectionUtils.isNotEmpty(sumDetailList)){
				for(SumGrapDetailVO vo : sumDetailList){
					if(vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())){
						parentMap.put(vo.getId(), vo);
					}
					if(!sumDetailMap.containsKey(vo.getId()) && !billId.equals(vo.getGrapId())){
						sumDetailMap.put(vo.getId(), vo);
					}
				}
			}
			// 构造子集
			if(CollectionUtils.isNotEmpty(sumDetailList)){
				for(SumGrapDetailVO vo : sumDetailList){
					Long parentId = vo.getParentId();
					if(parentMap.containsKey(parentId) && billId.equals(vo.getGrapId())){
						SumGrapDetailVO parentVO = parentMap.get(parentId);
						List<SumGrapDetailVO> children = parentVO.getChildren();
						if(!children.contains(vo)){
							children.add(vo);
						}
						parentMap.put(parentId, parentVO);
					}
				}
			}
			int parentRow = parentMap.size();// 非末级剩余行数
			if(parentRow != 0){
				// 重新计算非末级数据
				for(SumGrapDetailVO parentVO : parentMap.values()){
					List<SumGrapDetailVO> children = parentVO.getChildren();
					if(CollectionUtils.isNotEmpty(children)){
						BigDecimal num = null;// 汇总数量
						BigDecimal mny = null;// 汇总金额
						BigDecimal approveNum = null;// 汇总审批数量
						BigDecimal approveMny = null;// 汇总审批金额
						String construction = null;
						for(SumGrapDetailVO vo : children){
							num = DecimalUtils.add(num, vo.getNum());
							mny = DecimalUtils.add(mny, vo.getMny());
							approveNum = DecimalUtils.add(approveNum, vo.getApproveNum());
							approveMny = DecimalUtils.add(approveMny, vo.getApproveMny());
							construction = this.getSumStr(construction, vo.getConstruction());
						}
						parentVO.setNum(num);
						parentVO.setNum(mny);
						parentVO.setNum(approveNum);
						parentVO.setNum(approveMny);
						parentVO.setConstruction(construction);
						sumDetailMap.put(parentVO.getId(), parentVO);
					} else {
						sumDetailMap.remove(parentVO.getId());
						parentRow -= 1;
					}
				}
			}
			sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
			// 非末级行不为空则修改，否则删除
			if(parentRow > 0){
				sumGrapService.saveOrUpdate(sumGrapVO);
			} else {
				sumGrapService.removeById(sumGrapVO.getId());
			}
			// 防止entity污染，重新查询修改
			entity = grapService.selectById(billId);
			entity.setSumGrapId(null);
			grapService.updateById(entity);
		}
		return CommonResponse.success();
	}

}
