package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.grap.mapper.SumGrapMapper;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;

/**
 * 进度台账实体
 * 
 * @author generator
 * 
 */
@Service("sumGrapService")
public class SumGrapServiceImpl extends BaseServiceImpl<SumGrapMapper, SumGrapEntity> implements ISumGrapService{

    private static final String FBXT_SUM_GRAP = "FBXT_SUM_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public SumGrapVO saveOrUpdate(SumGrapVO saveorUpdateVO) {
        SumGrapEntity entity = BeanMapper.map(saveorUpdateVO, SumGrapEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_SUM_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, SumGrapVO.class);
    }
}
