/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapDetailService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.business.fbxt.util.UuidUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="grap")
public class GrapBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IGrapService grapService;
    @Autowired
    private ISumGrapService sumGrapService;
    @Autowired
    private ISumGrapDetailService sumGrapDetailService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        if (entity.getSumGrapId() != null) {
            List<GrapDetailEntity> detailList = entity.getDetailList();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SumGrapEntity::getContractId, (Object)entity.getContractId());
            wrapper.eq(SumGrapEntity::getBillState, (Object)0);
            List sumGrapList = this.sumGrapService.list((Wrapper)wrapper);
            SumGrapVO sumGrapVO = null;
            HashMap<String, SumGrapDetailVO> parentMap = new HashMap<String, SumGrapDetailVO>();
            HashMap<Long, SumGrapDetailVO> sumDetailMap = new HashMap<Long, SumGrapDetailVO>();
            if (CollectionUtils.isEmpty((Collection)sumGrapList)) {
                sumGrapVO = this.getSumGrapVO(entity);
                if (CollectionUtils.isNotEmpty(detailList)) {
                    for (GrapDetailEntity detail : detailList) {
                        this.dealSumDetailMap(entity, detail, parentMap, sumDetailMap);
                    }
                }
                sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
            } else {
                SumGrapEntity sumGrapEntity = (SumGrapEntity)((Object)this.sumGrapService.selectById(((SumGrapEntity)((Object)sumGrapList.get(0))).getId()));
                sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)sumGrapEntity), SumGrapVO.class);
                sumGrapVO.setMemo(this.getSumStr(sumGrapVO.getMemo(), entity.getMemo()));
                sumGrapVO.setSumMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumMny(), (BigDecimal)entity.getSumMny()));
                sumGrapVO.setSumApproveMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumApproveMny(), (BigDecimal)entity.getSumMny()));
                List sumDetailList = sumGrapVO.getDetailList();
                for (SumGrapDetailVO vo : sumDetailList) {
                    if (vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getInfoId())) {
                        parentMap.put(vo.getInfoId(), vo);
                    }
                    if (sumDetailMap.containsKey(vo.getId())) continue;
                    sumDetailMap.put(vo.getId(), vo);
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    for (GrapDetailEntity detail : detailList) {
                        this.dealSumDetailMap(entity, detail, parentMap, sumDetailMap);
                    }
                    sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
                }
            }
            this.sumGrapService.saveOrUpdate(sumGrapVO);
            entity = (GrapEntity)((Object)this.grapService.selectById(billId));
            entity.setSumGrapId(sumGrapVO.getId());
            this.grapService.updateById((Object)entity);
        }
        return CommonResponse.success();
    }

    private SumGrapVO getSumGrapVO(GrapEntity entity) {
        SumGrapVO vo = new SumGrapVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectSourceId(entity.getProjectSourceId());
        vo.setContractId(entity.getContractId());
        vo.setContractCode(entity.getContractCode());
        vo.setContractName(entity.getContractName());
        vo.setCropId(entity.getCropId());
        vo.setCropSourceId(entity.getCropSourceId());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgName(entity.getOrgName());
        vo.setOrgSourceId(entity.getOrgSourceId());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setSupplierSourceId(entity.getSupplierSourceId());
        vo.setCreateUserId(InvocationInfoProxy.getUserid());
        vo.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(entity.getCreateDate()));
        vo.setSumMny(entity.getSumMny());
        vo.setSumApproveMny(entity.getSumMny());
        vo.setMemo(entity.getMemo());
        return vo;
    }

    private void dealSumDetailMap(GrapEntity entity, GrapDetailEntity detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
        String infoId = detail.getInfoId();
        SumGrapDetailVO vo = new SumGrapDetailVO();
        vo.setGrapId(entity.getId());
        vo.setGrapDetailId(detail.getId());
        vo.setInfoId(detail.getInfoId());
        vo.setNum(detail.getNum());
        vo.setApproveNum(detail.getNum());
        vo.setMny(detail.getMny());
        vo.setApproveMny(detail.getMny());
        vo.setConstruction(entity.getConstruction());
        vo.setMemo(entity.getMemo());
        vo.setCommitUserId(entity.getCreateUserId());
        vo.setCommitUserName(entity.getCreateUserName());
        Long parentId = null;
        SumGrapDetailVO parentVO = null;
        if (!parentMap.containsKey(infoId)) {
            parentId = Long.valueOf(UuidUtil.getGuid());
            parentVO = new SumGrapDetailVO();
            parentVO.setId(parentId);
            parentVO.setInfoId(detail.getInfoId());
            parentVO.setInfoCode(detail.getInfoCode());
            parentVO.setInfoName(detail.getInfoName());
            parentVO.setUnit(detail.getUnit());
            parentVO.setPrice(detail.getPrice());
            parentVO.setNum(detail.getNum());
            parentVO.setApproveNum(detail.getNum());
            parentVO.setMny(detail.getMny());
            parentVO.setApproveMny(detail.getMny());
            parentVO.setConstruction(entity.getConstruction());
            parentVO.setLeafFlag(Integer.valueOf(0));
            parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));
            parentMap.put(infoId, parentVO);
        } else {
            parentVO = parentMap.get(infoId);
            parentId = parentVO.getId();
            parentVO.setNum(DecimalUtils.add((BigDecimal)parentVO.getNum(), (BigDecimal)detail.getNum()));
            parentVO.setApproveNum(DecimalUtils.add((BigDecimal)parentVO.getApproveNum(), (BigDecimal)detail.getNum()));
            parentVO.setMny(DecimalUtils.add((BigDecimal)parentVO.getMny(), (BigDecimal)detail.getMny()));
            parentVO.setApproveMny(DecimalUtils.add((BigDecimal)parentVO.getApproveMny(), (BigDecimal)detail.getMny()));
            String construction = this.getSumStr(parentVO.getConstruction(), entity.getConstruction());
            parentVO.setConstruction(construction);
        }
        sumDetailMap.put(parentId, parentVO);
        vo.setLeafFlag(Integer.valueOf(1));
        vo.setParentId(parentId);
        vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));
        sumDetailMap.put(detail.getId(), vo);
    }

    private String getSumStr(String sumStr, String str) {
        if (!StringUtils.isNotEmpty((String)str)) {
            return sumStr;
        }
        str = str.replaceAll(" ", "");
        if (StringUtils.isNotEmpty((String)sumStr)) {
            String[] strs = sumStr.split(",");
            HashSet<String> strSet = new HashSet<String>(Arrays.asList(strs));
            if (!strSet.contains(str)) {
                sumStr = sumStr + "," + str;
            }
            return sumStr;
        }
        return str;
    }

    private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
        int index = 1;
        for (SumGrapDetailVO vo : map.values()) {
            if (!parentId.equals(vo.getParentId())) continue;
            ++index;
        }
        return index;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        if (entity.getSumGrapId() != null) {
            int parentRow;
            SumGrapEntity sumGrapEntity = (SumGrapEntity)((Object)this.sumGrapService.selectById(entity.getSumGrapId()));
            SumGrapVO sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)sumGrapEntity), SumGrapVO.class);
            List sumDetailList = sumGrapVO.getDetailList();
            HashMap<Long, SumGrapDetailVO> parentMap = new HashMap<Long, SumGrapDetailVO>();
            HashMap<Long, SumGrapDetailVO> sumDetailMap = new HashMap<Long, SumGrapDetailVO>();
            if (CollectionUtils.isNotEmpty((Collection)sumDetailList)) {
                for (SumGrapDetailVO vo : sumDetailList) {
                    if (vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())) {
                        parentMap.put(vo.getId(), vo);
                    }
                    if (sumDetailMap.containsKey(vo.getId()) || billId.equals(vo.getGrapId())) continue;
                    sumDetailMap.put(vo.getId(), vo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)sumDetailList)) {
                for (SumGrapDetailVO vo : sumDetailList) {
                    Long parentId = vo.getParentId();
                    if (!parentMap.containsKey(parentId) || !billId.equals(vo.getGrapId())) continue;
                    SumGrapDetailVO parentVO = (SumGrapDetailVO)parentMap.get(parentId);
                    List children = parentVO.getChildren();
                    if (!children.contains(vo)) {
                        children.add(vo);
                    }
                    parentMap.put(parentId, parentVO);
                }
            }
            if ((parentRow = parentMap.size()) != 0) {
                for (SumGrapDetailVO parentVO : parentMap.values()) {
                    List children = parentVO.getChildren();
                    if (CollectionUtils.isNotEmpty((Collection)children)) {
                        BigDecimal num = null;
                        BigDecimal mny = null;
                        BigDecimal approveNum = null;
                        BigDecimal approveMny = null;
                        String construction = null;
                        for (SumGrapDetailVO vo : children) {
                            num = DecimalUtils.add(num, (BigDecimal)vo.getNum());
                            mny = DecimalUtils.add(mny, (BigDecimal)vo.getMny());
                            approveNum = DecimalUtils.add(approveNum, (BigDecimal)vo.getApproveNum());
                            approveMny = DecimalUtils.add(approveMny, (BigDecimal)vo.getApproveMny());
                            construction = this.getSumStr(construction, vo.getConstruction());
                        }
                        parentVO.setNum(num);
                        parentVO.setNum(mny);
                        parentVO.setNum(approveNum);
                        parentVO.setNum(approveMny);
                        parentVO.setConstruction(construction);
                        sumDetailMap.put(parentVO.getId(), parentVO);
                        continue;
                    }
                    sumDetailMap.remove(parentVO.getId());
                    --parentRow;
                }
            }
            sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
            if (parentRow > 0) {
                this.sumGrapService.saveOrUpdate(sumGrapVO);
            } else {
                this.sumGrapService.removeById(sumGrapVO.getId());
            }
            entity = (GrapEntity)((Object)this.grapService.selectById(billId));
            entity.setSumGrapId(null);
            this.grapService.updateById((Object)entity);
        }
        return CommonResponse.success();
    }
}

